/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.DateVectorGetter;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.ValueVector;

public class DateVectorAccessor
extends QueryJDBCAccessor {
    private final DateVectorGetter.Getter getter;
    private final TimeUnit timeUnit;
    private final DateVectorGetter.Holder holder = new DateVectorGetter.Holder();
    private static final String INVALID_VECTOR_ERROR_RESPONSE = "Invalid Arrow vector provided";

    public DateVectorAccessor(DateDayVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = DateVectorGetter.createGetter(vector);
        this.timeUnit = DateVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    public DateVectorAccessor(DateMilliVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = DateVectorGetter.createGetter(vector);
        this.timeUnit = DateVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject() {
        return this.getDate(null);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        Date date = this.getDate(calendar);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    @Override
    public Date getDate(Calendar calendar) {
        this.fillHolder();
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        long milliseconds = this.timeUnit.toMillis(value);
        return DateTimeUtils.getUTCDateFromMilliseconds(milliseconds);
    }

    @Override
    public String getString() {
        Date date = this.getDate(null);
        if (date == null) {
            return null;
        }
        return date.toLocalDate().toString();
    }

    private void fillHolder() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
    }

    protected static TimeUnit getTimeUnitForVector(ValueVector vector) throws SQLException {
        if (vector instanceof DateDayVector) {
            return TimeUnit.DAYS;
        }
        if (vector instanceof DateMilliVector) {
            return TimeUnit.MILLISECONDS;
        }
        IllegalArgumentException rootCauseException = new IllegalArgumentException(INVALID_VECTOR_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_VECTOR_ERROR_RESPONSE, "22007", rootCauseException);
    }
}

