/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.BaseListVectorAccessor;
import java.sql.SQLException;
import java.util.function.IntSupplier;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.LargeListVector;

public class LargeListVectorAccessor
extends BaseListVectorAccessor {
    private final LargeListVector vector;

    public LargeListVectorAccessor(LargeListVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(currentRowSupplier, wasNullConsumer);
        this.vector = vector;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getListObject(arg_0 -> ((LargeListVector)this.vector).getObject(arg_0));
    }

    @Override
    protected long getStartOffset(int index) {
        ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
        return offsetBuffer.getInt((long)index * 8L);
    }

    @Override
    protected long getEndOffset(int index) {
        ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
        return offsetBuffer.getInt((long)(index + 1) * 8L);
    }

    @Override
    protected FieldVector getDataVector() {
        return this.vector.getDataVector();
    }

    @Override
    protected boolean isNull(int index) {
        return this.vector.isNull(index);
    }
}

