/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusPoller;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.hyperdb.grpc.ExecuteQueryResponse;
import com.salesforce.hyperdb.grpc.QueryInfo;
import com.salesforce.hyperdb.grpc.QueryResult;
import com.salesforce.hyperdb.grpc.QueryStatus;
import io.grpc.StatusRuntimeException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveQueryStatusPoller
implements QueryStatusPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdaptiveQueryStatusPoller.class);
    private final AtomicLong chunks = new AtomicLong(1L);
    private final AtomicReference<QueryStatus> lastStatus = new AtomicReference();
    private final String queryId;
    private final HyperGrpcClientExecutor client;

    private Iterator<QueryInfo> getQueryInfoStreaming() {
        try {
            return this.client.getQueryInfoStreaming(this.queryId);
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createException("Failed when getting query status", (Exception)((Object)ex));
        }
    }

    public Optional<QueryResult> map(ExecuteQueryResponse item) {
        this.getQueryStatus(item).ifPresent(this::handleQueryStatus);
        return this.getQueryResult(item);
    }

    private void handleQueryStatus(QueryStatus status) {
        this.lastStatus.set(status);
        if (status.getChunkCount() > 1L) {
            this.chunks.set(status.getChunkCount());
        }
    }

    private Optional<QueryStatus> getQueryStatus(ExecuteQueryResponse item) {
        QueryInfo info;
        if (item != null && item.hasQueryInfo() && (info = item.getQueryInfo()).hasQueryStatus()) {
            return Optional.of(info.getQueryStatus());
        }
        return Optional.empty();
    }

    private Optional<QueryResult> getQueryResult(ExecuteQueryResponse item) {
        if (item != null && item.hasQueryResult()) {
            return Optional.of(item.getQueryResult());
        }
        return Optional.empty();
    }

    @Override
    public QueryStatus pollQueryStatus() {
        return this.lastStatus.get();
    }

    @Override
    public long pollChunkCount() {
        Optional<QueryStatus> status = Optional.ofNullable(this.lastStatus.get());
        Boolean finalized = status.map(QueryStatus::getCompletionStatus).map((? super T t) -> t == QueryStatus.CompletionStatus.FINISHED || t == QueryStatus.CompletionStatus.RESULTS_PRODUCED).orElse(false);
        if (finalized.booleanValue()) {
            return this.chunks.get();
        }
        Iterator<QueryInfo> queryInfos = this.getQueryInfoStreaming();
        Optional<QueryStatus> result = StreamUtilities.toStream(queryInfos).map(Optional::ofNullable).filter(Optional::isPresent).map(Optional::get).map(QueryInfo::getQueryStatus).filter(AdaptiveQueryStatusPoller::isChunksCompleted).findFirst();
        result.ifPresent(it -> {
            QueryStatus.CompletionStatus completion = it.getCompletionStatus();
            long chunkCount = it.getChunkCount();
            log.info("Polling chunk count. queryId={}, status={}, count={}", new Object[]{this.queryId, completion, chunkCount});
            this.chunks.set(chunkCount);
        });
        return this.chunks.get();
    }

    private static boolean isChunksCompleted(QueryStatus s) {
        QueryStatus.CompletionStatus completion = s.getCompletionStatus();
        return completion == QueryStatus.CompletionStatus.RESULTS_PRODUCED || completion == QueryStatus.CompletionStatus.FINISHED;
    }

    @Generated
    AdaptiveQueryStatusPoller(String queryId, HyperGrpcClientExecutor client) {
        this.queryId = queryId;
        this.client = client;
    }
}

