/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.StreamingResultSet;
import com.salesforce.datacloud.jdbc.core.listener.AsyncQueryStatusPoller;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.hyperdb.grpc.ExecuteQueryResponse;
import com.salesforce.hyperdb.grpc.QueryResult;
import com.salesforce.hyperdb.grpc.QueryStatus;
import io.grpc.StatusRuntimeException;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryStatusListener
implements QueryStatusListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncQueryStatusListener.class);
    private final String queryId;
    private final String query;
    private final HyperGrpcClientExecutor client;
    private final AtomicReference<Object> poller = new AtomicReference();

    public static AsyncQueryStatusListener of(String query, HyperGrpcClientExecutor client) throws SQLException {
        try {
            ExecuteQueryResponse result = client.executeAsyncQuery(query).next();
            String id = result.getQueryInfo().getQueryStatus().getQueryId();
            return AsyncQueryStatusListener.builder().queryId(id).query(query).client(client).build();
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createException("Failed to execute query: " + query, (Exception)((Object)ex));
        }
    }

    @Override
    public boolean isReady() {
        return this.getPoller().pollIsReady();
    }

    @Override
    public String getStatus() {
        return Optional.of(this.getPoller()).map(AsyncQueryStatusPoller::pollQueryStatus).map(QueryStatus::getCompletionStatus).map(Enum::name).orElse(null);
    }

    @Override
    public DataCloudResultSet generateResultSet() {
        return StreamingResultSet.of(this.query, this);
    }

    @Override
    public Stream<QueryResult> stream() throws SQLException {
        return StreamUtilities.lazyLimitedStream(this::infiniteChunks, this::getChunkLimit).flatMap(UnaryOperator.identity());
    }

    private Stream<Stream<QueryResult>> infiniteChunks() {
        return LongStream.iterate(0L, n -> n + 1L).mapToObj(this::tryGetQueryResult);
    }

    private long getChunkLimit() {
        if (!this.isReady()) {
            throw new DataCloudJDBCException("Results were requested before ready");
        }
        return this.getPoller().pollChunkCount();
    }

    private Stream<QueryResult> tryGetQueryResult(long chunkId) {
        return StreamUtilities.tryTimes(3, () -> this.client.getQueryResult(this.queryId, chunkId, chunkId > 0L), throwable -> log.warn("Error when getting chunk for query. queryId={}, chunkId={}", new Object[]{this.queryId, chunkId, throwable})).map(StreamUtilities::toStream).orElse(Stream.empty());
    }

    @Generated
    AsyncQueryStatusListener(String queryId, String query, HyperGrpcClientExecutor client) {
        this.queryId = queryId;
        this.query = query;
        this.client = client;
    }

    @Generated
    private static AsyncQueryStatusListenerBuilder builder() {
        return new AsyncQueryStatusListenerBuilder();
    }

    @Override
    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @Generated
    public String getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private AsyncQueryStatusPoller getPoller() {
        Object $value = this.poller.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.poller;
            synchronized (atomicReference) {
                $value = this.poller.get();
                if ($value == null) {
                    AsyncQueryStatusPoller actualValue = new AsyncQueryStatusPoller(this.queryId, this.client);
                    $value = actualValue == null ? this.poller : actualValue;
                    this.poller.set($value);
                }
            }
        }
        return (AsyncQueryStatusPoller)($value == this.poller ? null : $value);
    }

    @Generated
    private static class AsyncQueryStatusListenerBuilder {
        @Generated
        private String queryId;
        @Generated
        private String query;
        @Generated
        private HyperGrpcClientExecutor client;

        @Generated
        AsyncQueryStatusListenerBuilder() {
        }

        @Generated
        private AsyncQueryStatusListenerBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        private AsyncQueryStatusListenerBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        private AsyncQueryStatusListenerBuilder client(HyperGrpcClientExecutor client) {
            this.client = client;
            return this;
        }

        @Generated
        private AsyncQueryStatusListener build() {
            return new AsyncQueryStatusListener(this.queryId, this.query, this.client);
        }

        @Generated
        public String toString() {
            return "AsyncQueryStatusListener.AsyncQueryStatusListenerBuilder(queryId=" + this.queryId + ", query=" + this.query + ", client=" + this.client + ")";
        }
    }
}

