/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusPoller;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.hyperdb.grpc.QueryInfo;
import com.salesforce.hyperdb.grpc.QueryStatus;
import io.grpc.StatusRuntimeException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

class AsyncQueryStatusPoller
implements QueryStatusPoller {
    private final String queryId;
    private final HyperGrpcClientExecutor client;
    private final AtomicReference<QueryStatus> lastStatus = new AtomicReference();

    private Optional<QueryInfo> getQueryInfo() {
        try {
            return Optional.ofNullable(this.client.getQueryInfo(this.queryId)).map(Iterator::next);
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createException("Failed when getting query status", (Exception)((Object)ex));
        }
    }

    private Optional<QueryStatus> fetchQueryStatus() {
        Optional<QueryStatus> status = this.getQueryInfo().map(QueryInfo::getQueryStatus);
        if (status.isPresent()) {
            this.lastStatus.set(status.get());
        }
        return status;
    }

    @Override
    public QueryStatus pollQueryStatus() {
        Optional<QueryStatus> status = Optional.ofNullable(this.lastStatus.get());
        Boolean finished = status.map(QueryStatus::getCompletionStatus).map(t -> t == QueryStatus.CompletionStatus.FINISHED).orElse(false);
        return finished != false ? status.get() : (QueryStatus)this.fetchQueryStatus().orElse(null);
    }

    @Override
    public long pollChunkCount() throws SQLException {
        if (!this.pollIsReady()) {
            throw new DataCloudJDBCException("Results were requested before ready");
        }
        return this.lastStatus.get().getChunkCount();
    }

    @Generated
    AsyncQueryStatusPoller(String queryId, HyperGrpcClientExecutor client) {
        this.queryId = queryId;
        this.client = client;
    }
}

