/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.StreamingResultSet;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.hyperdb.grpc.ExecuteQueryResponse;
import com.salesforce.hyperdb.grpc.QueryInfo;
import com.salesforce.hyperdb.grpc.QueryResult;
import com.salesforce.hyperdb.grpc.QueryStatus;
import io.grpc.StatusRuntimeException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncQueryStatusListener
implements QueryStatusListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncQueryStatusListener.class);
    private final String queryId;
    private final String query;
    private final AtomicReference<QueryStatus> status = new AtomicReference();
    private final Iterator<ExecuteQueryResponse> initial;

    public static SyncQueryStatusListener of(String query, HyperGrpcClientExecutor client) throws SQLException {
        Iterator<ExecuteQueryResponse> result = client.executeQuery(query);
        try {
            String id = SyncQueryStatusListener.getQueryId(result.next(), query);
            return SyncQueryStatusListener.builder().query(query).queryId(id).initial(result).build();
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createException("Failed to execute query: " + query, (Exception)((Object)ex));
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public String getStatus() {
        return Optional.ofNullable(this.status.get()).map(QueryStatus::getCompletionStatus).map(Enum::name).orElse(null);
    }

    @Override
    public DataCloudResultSet generateResultSet() {
        return StreamingResultSet.of(this.query, this);
    }

    @Override
    public Stream<QueryResult> stream() throws SQLException {
        return StreamUtilities.toStream(this.initial).peek(this::peekQueryStatus).map(SyncQueryStatusListener::extractQueryResult).filter(Optional::isPresent).map(Optional::get);
    }

    private static Optional<QueryResult> extractQueryResult(ExecuteQueryResponse response) {
        return Optional.ofNullable(response).map(ExecuteQueryResponse::getQueryResult);
    }

    private void peekQueryStatus(ExecuteQueryResponse response) {
        Optional.ofNullable(response).map(ExecuteQueryResponse::getQueryInfo).map(QueryInfo::getQueryStatus).ifPresent(this.status::set);
    }

    private static String getQueryId(ExecuteQueryResponse response, String query) {
        String rootErrorMessage = "The server did not supply an ID for the query: " + query;
        return Optional.ofNullable(response).map(ExecuteQueryResponse::getQueryInfo).map(QueryInfo::getQueryStatus).map(QueryStatus::getQueryId).orElseThrow(() -> new DataCloudJDBCException(rootErrorMessage, new IllegalStateException(rootErrorMessage)));
    }

    @Generated
    SyncQueryStatusListener(String queryId, String query, Iterator<ExecuteQueryResponse> initial) {
        this.queryId = queryId;
        this.query = query;
        this.initial = initial;
    }

    @Generated
    private static SyncQueryStatusListenerBuilder builder() {
        return new SyncQueryStatusListenerBuilder();
    }

    @Override
    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    private static class SyncQueryStatusListenerBuilder {
        @Generated
        private String queryId;
        @Generated
        private String query;
        @Generated
        private Iterator<ExecuteQueryResponse> initial;

        @Generated
        SyncQueryStatusListenerBuilder() {
        }

        @Generated
        private SyncQueryStatusListenerBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        private SyncQueryStatusListenerBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        private SyncQueryStatusListenerBuilder initial(Iterator<ExecuteQueryResponse> initial) {
            this.initial = initial;
            return this;
        }

        @Generated
        private SyncQueryStatusListener build() {
            return new SyncQueryStatusListener(this.queryId, this.query, this.initial);
        }

        @Generated
        public String toString() {
            return "SyncQueryStatusListener.SyncQueryStatusListenerBuilder(queryId=" + this.queryId + ", query=" + this.query + ", initial=" + this.initial + ")";
        }
    }
}

