/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.salesforce.datacloud.jdbc.core.model.ParameterBinding;
import com.salesforce.datacloud.jdbc.util.VectorPopulator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.proto.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrowUtils.class);
    private static final Map<Integer, Function<ParameterBinding, FieldType>> SQL_TYPE_TO_FIELD_TYPE = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Maps.immutableEntry((Object)12, pb -> FieldType.nullable((ArrowType)new ArrowType.Utf8())), Maps.immutableEntry((Object)4, pb -> FieldType.nullable((ArrowType)new ArrowType.Int(32, true))), Maps.immutableEntry((Object)-5, pb -> FieldType.nullable((ArrowType)new ArrowType.Int(64, true))), Maps.immutableEntry((Object)16, pb -> FieldType.nullable((ArrowType)new ArrowType.Bool())), Maps.immutableEntry((Object)-6, pb -> FieldType.nullable((ArrowType)new ArrowType.Int(8, true))), Maps.immutableEntry((Object)5, pb -> FieldType.nullable((ArrowType)new ArrowType.Int(16, true))), Maps.immutableEntry((Object)91, pb -> FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY))), Maps.immutableEntry((Object)92, pb -> FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64))), Maps.immutableEntry((Object)93, pb -> FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC"))), Maps.immutableEntry((Object)6, pb -> FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE))), Maps.immutableEntry((Object)8, pb -> FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE))), Maps.immutableEntry((Object)3, ArrowUtils::createDecimalFieldType), Maps.immutableEntry((Object)2003, pb -> FieldType.nullable((ArrowType)new ArrowType.List()))});

    public static List<ColumnMetaData> toColumnMetaData(List<Field> fields) {
        AtomicInteger index = new AtomicInteger();
        return fields.stream().map(field -> {
            try {
                return ArrowUtils.fieldToColumnMetaData(field, index.getAndIncrement());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private static ColumnMetaData fieldToColumnMetaData(Field field, int index) throws SQLException {
        Common.ColumnMetaData.Builder builder = Common.ColumnMetaData.newBuilder().setOrdinal(index).setColumnName(field.getName()).setLabel(field.getName()).setType(ArrowUtils.getAvaticaType(field.getType()).toProto());
        return ColumnMetaData.fromProto((Common.ColumnMetaData)builder.build());
    }

    public static List<ColumnMetaData> convertJDBCMetadataToAvaticaColumns(ResultSetMetaData metaData, int maxSize) {
        if (metaData == null) {
            return Collections.emptyList();
        }
        return Stream.iterate(1, i -> i + 1).limit(maxSize).map(i -> {
            try {
                ColumnMetaData.AvaticaType avaticaType = ArrowUtils.getAvaticaType(metaData.getColumnType((int)i), metaData.getColumnTypeName((int)i));
                return new ColumnMetaData(i - 1, metaData.isAutoIncrement((int)i), metaData.isCaseSensitive((int)i), metaData.isSearchable((int)i), metaData.isCurrency((int)i), metaData.isNullable((int)i), metaData.isSigned((int)i), metaData.getColumnDisplaySize((int)i), metaData.getColumnLabel((int)i), metaData.getColumnName((int)i), metaData.getSchemaName((int)i), metaData.getPrecision((int)i), metaData.getScale((int)i), metaData.getTableName((int)i), metaData.getCatalogName((int)i), avaticaType, metaData.isReadOnly((int)i), metaData.isWritable((int)i), metaData.isDefinitelyWritable((int)i), metaData.getColumnClassName((int)i));
            }
            catch (SQLException e) {
                log.error("Error converting JDBC Metadata to Avatica Columns");
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static Schema createSchemaFromParameters(List<ParameterBinding> parameterBindings) {
        if (parameterBindings == null) {
            throw new IllegalArgumentException("ParameterBindings list cannot be null");
        }
        List fields = IntStream.range(0, parameterBindings.size()).mapToObj(i -> ArrowUtils.createField((ParameterBinding)parameterBindings.get(i), i + 1)).collect(Collectors.toList());
        return new Schema(fields);
    }

    private static Field createField(ParameterBinding parameterBinding, int index) {
        FieldType fieldType = ArrowUtils.determineFieldType(parameterBinding);
        return new Field(String.valueOf(index), fieldType, null);
    }

    private static FieldType determineFieldType(ParameterBinding parameterBinding) {
        if (parameterBinding == null) {
            return FieldType.nullable((ArrowType)new ArrowType.Utf8());
        }
        int sqlType = parameterBinding.getSqlType();
        Function<ParameterBinding, FieldType> fieldTypeFunction = SQL_TYPE_TO_FIELD_TYPE.get(sqlType);
        if (fieldTypeFunction != null) {
            return fieldTypeFunction.apply(parameterBinding);
        }
        throw new IllegalArgumentException("Unsupported SQL type: " + sqlType);
    }

    private static FieldType createDecimalFieldType(ParameterBinding parameterBinding) {
        if (parameterBinding.getValue() instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)parameterBinding.getValue();
            return FieldType.nullable((ArrowType)new ArrowType.Decimal(bd.precision(), bd.scale(), 128));
        }
        throw new IllegalArgumentException("Decimal type requires a BigDecimal value");
    }

    public static byte[] toArrowByteArray(List<ParameterBinding> parameters, Calendar calendar) throws IOException {
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        Schema schema = ArrowUtils.createSchemaFromParameters(parameters);
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            root.allocateNew();
            VectorPopulator.populateVectors(root, parameters, calendar);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, (OutputStream)outputStream);){
                writer.start();
                writer.writeBatch();
                writer.end();
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static int getSQLTypeFromArrowType(ArrowType arrowType) {
        ArrowType.ArrowTypeID typeId = arrowType.getTypeID();
        switch (typeId) {
            case Int: {
                return ArrowUtils.getSQLTypeForInt((ArrowType.Int)arrowType);
            }
            case Bool: {
                return 16;
            }
            case Utf8: {
                return 12;
            }
            case LargeUtf8: {
                return -1;
            }
            case Binary: {
                return -3;
            }
            case FixedSizeBinary: {
                return -2;
            }
            case LargeBinary: {
                return -4;
            }
            case FloatingPoint: {
                return ArrowUtils.getSQLTypeForFloatingPoint((ArrowType.FloatingPoint)arrowType);
            }
            case Decimal: {
                return 3;
            }
            case Date: {
                return 91;
            }
            case Time: {
                return 92;
            }
            case Timestamp: {
                return 93;
            }
            case List: 
            case LargeList: 
            case FixedSizeList: {
                return 2003;
            }
            case Map: 
            case Duration: 
            case Union: 
            case Interval: {
                return 2000;
            }
            case Struct: {
                return 2002;
            }
            case NONE: 
            case Null: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported Arrow type: " + arrowType);
    }

    private static int getSQLTypeForInt(ArrowType.Int arrowType) {
        int bitWidth = arrowType.getBitWidth();
        switch (bitWidth) {
            case 8: {
                return -6;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 64: {
                return -5;
            }
        }
        throw new IllegalArgumentException("Unsupported Arrow Integer Bit Width: " + bitWidth);
    }

    private static int getSQLTypeForFloatingPoint(ArrowType.FloatingPoint arrowType) {
        FloatingPointPrecision precision = arrowType.getPrecision();
        switch (precision) {
            case SINGLE: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unsupported Arrow Floating Point: " + precision);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(ArrowType arrowType) throws SQLException {
        int sqlType = ArrowUtils.getSQLTypeFromArrowType(arrowType);
        return ArrowUtils.getAvaticaType(sqlType, JDBCType.valueOf(sqlType).getName());
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(int type, String typeName) throws SQLException {
        ColumnMetaData.ArrayType avaticaType;
        SqlType sqlType = SqlType.valueOf((int)type);
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of((Type)sqlType.internal);
        if (sqlType == SqlType.ARRAY || sqlType == SqlType.STRUCT || sqlType == SqlType.MULTISET) {
            ColumnMetaData.ScalarType arrayValueType = ColumnMetaData.scalar((int)2000, (String)typeName, (ColumnMetaData.Rep)ColumnMetaData.Rep.OBJECT);
            avaticaType = ColumnMetaData.array((ColumnMetaData.AvaticaType)arrayValueType, (String)typeName, (ColumnMetaData.Rep)rep);
        } else {
            avaticaType = ColumnMetaData.scalar((int)type, (String)typeName, (ColumnMetaData.Rep)rep);
        }
        return avaticaType;
    }

    @Generated
    private ArrowUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

