/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.StringCompatibility;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;

public final class PropertiesExtensions {
    public static Optional<String> optional(Properties properties, String key) {
        if (properties == null) {
            return Optional.empty();
        }
        if (key == null || !properties.containsKey(key)) {
            return Optional.empty();
        }
        String value = properties.getProperty(key);
        return value == null || StringCompatibility.isBlank(value) ? Optional.empty() : Optional.of(value);
    }

    public static String required(Properties properties, String key) {
        Optional<String> result = PropertiesExtensions.optional(properties, key);
        if (!result.isPresent()) {
            throw new IllegalArgumentException("Properties missing required value for key: " + key);
        }
        return result.get();
    }

    public static Properties copy(Properties properties, Set<String> filterKeys) {
        Properties result = new Properties();
        for (String key : filterKeys) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            result.setProperty(key, value);
        }
        return result;
    }

    public static Integer getIntegerOrDefault(Properties properties, String key, Integer defaultValue) {
        return PropertiesExtensions.optional(properties, key).map(PropertiesExtensions::toIntegerOrNull).orElse(defaultValue);
    }

    public static Integer toIntegerOrNull(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Boolean getBooleanOrDefault(Properties properties, String key, Boolean defaultValue) {
        return PropertiesExtensions.optional(properties, key).map(PropertiesExtensions::toBooleanOrDefault).orElse(defaultValue);
    }

    public static Boolean toBooleanOrDefault(String s) {
        return Boolean.valueOf(s);
    }

    @Generated
    private PropertiesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static final class Messages {
        static final String REQUIRED_MISSING_PREFIX = "Properties missing required value for key: ";

        @Generated
        private Messages() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

