/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.BaseVectorSetter;
import com.salesforce.datacloud.jdbc.util.DateTimeUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.arrow.vector.TimeStampMicroTZVector;

class TimeStampMicroTZVectorSetter
extends BaseVectorSetter<TimeStampMicroTZVector, Timestamp> {
    private final Calendar calendar;

    TimeStampMicroTZVectorSetter(Calendar calendar) {
        super(Timestamp.class);
        this.calendar = calendar;
    }

    @Override
    protected void setValueInternal(TimeStampMicroTZVector vector, Timestamp value) {
        LocalDateTime localDateTime = value.toLocalDateTime();
        localDateTime = DateTimeUtils.adjustForCalendar(localDateTime, this.calendar, TimeZone.getTimeZone("UTC"));
        long microsecondsSinceEpoch = DateTimeUtils.localDateTimeToMicrosecondsSinceEpoch(localDateTime);
        vector.setSafe(0, microsecondsSinceEpoch);
    }

    @Override
    protected void setNullValue(TimeStampMicroTZVector vector) {
        vector.setNull(0);
    }
}

