/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.salesforce.datacloud.jdbc.util.BigIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.BitVectorSetter;
import com.salesforce.datacloud.jdbc.util.DateDayVectorSetter;
import com.salesforce.datacloud.jdbc.util.DecimalVectorSetter;
import com.salesforce.datacloud.jdbc.util.Float4VectorSetter;
import com.salesforce.datacloud.jdbc.util.Float8VectorSetter;
import com.salesforce.datacloud.jdbc.util.IntVectorSetter;
import com.salesforce.datacloud.jdbc.util.SmallIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeMicroVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeStampMicroTZVectorSetter;
import com.salesforce.datacloud.jdbc.util.TinyIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.VarCharVectorSetter;
import com.salesforce.datacloud.jdbc.util.VectorValueSetter;
import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;

class VectorValueSetterFactory {
    private final Map<Class<? extends ValueVector>, VectorValueSetter<?>> setterMap;

    VectorValueSetterFactory(Calendar calendar) {
        this.setterMap = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Maps.immutableEntry(VarCharVector.class, (Object)new VarCharVectorSetter()), Maps.immutableEntry(Float4Vector.class, (Object)new Float4VectorSetter()), Maps.immutableEntry(Float8Vector.class, (Object)new Float8VectorSetter()), Maps.immutableEntry(IntVector.class, (Object)new IntVectorSetter()), Maps.immutableEntry(SmallIntVector.class, (Object)new SmallIntVectorSetter()), Maps.immutableEntry(BigIntVector.class, (Object)new BigIntVectorSetter()), Maps.immutableEntry(BitVector.class, (Object)new BitVectorSetter()), Maps.immutableEntry(DecimalVector.class, (Object)new DecimalVectorSetter()), Maps.immutableEntry(DateDayVector.class, (Object)new DateDayVectorSetter()), Maps.immutableEntry(TimeMicroVector.class, (Object)new TimeMicroVectorSetter(calendar)), Maps.immutableEntry(TimeStampMicroTZVector.class, (Object)new TimeStampMicroTZVectorSetter(calendar)), Maps.immutableEntry(TinyIntVector.class, (Object)new TinyIntVectorSetter())});
    }

    <T extends ValueVector> VectorValueSetter<T> getSetter(Class<T> vectorClass) {
        return this.setterMap.get(vectorClass);
    }
}

