/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.DataCloudTokenProcessor;
import com.salesforce.datacloud.jdbc.config.DriverVersion;
import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import com.salesforce.datacloud.jdbc.core.DataCloudConnectionString;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.interceptor.AuthorizationHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.TokenProcessorSupplier;
import com.salesforce.datacloud.jdbc.interceptor.TracingHeadersInterceptor;
import com.salesforce.datacloud.jdbc.soql.DataspaceClient;
import com.salesforce.datacloud.jdbc.util.DirectDataCloudConnection;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannelBuilder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudJDBCDriver
implements Driver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudJDBCDriver.class);
    private static Driver registeredDriver;

    private static synchronized void register() throws SQLException {
        if (DataCloudJDBCDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        registeredDriver = new DataCloudJDBCDriver();
        DriverManager.registerDriver(registeredDriver);
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        log.info("connect url={}", (Object)url);
        if (url == null) {
            throw new SQLException("Error occurred while registering JDBC driver. URL is null.");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            if (DirectDataCloudConnection.isDirect(info)) {
                log.info("Using direct connection");
                return DirectDataCloudConnection.of(url, info);
            }
            log.info("Using OAuth-based connection");
            return DataCloudJDBCDriver.oauthBasedConnection(url, info);
        }
        catch (Exception e) {
            log.error("Failed to connect with URL {}: {}", url, e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return DataCloudConnectionString.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return DriverVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return DriverVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    private static DataCloudTokenProcessor getDataCloudTokenProcessor(Properties properties) throws DataCloudJDBCException {
        if (!AuthenticationSettings.hasAny(properties)) {
            throw new DataCloudJDBCException("No authentication settings provided");
        }
        return DataCloudTokenProcessor.of(properties);
    }

    static DataCloudConnection oauthBasedConnection(String url, Properties properties) throws SQLException {
        DataCloudConnectionString connectionString = DataCloudConnectionString.of(url);
        DataCloudJDBCDriver.addClientUsernameIfRequired(properties);
        connectionString.withParameters(properties);
        properties.setProperty("loginURL", connectionString.getLoginUrl());
        DataCloudTokenProcessor tokenProcessor = DataCloudJDBCDriver.getDataCloudTokenProcessor(properties);
        AuthorizationHeaderInterceptor authInterceptor = TokenProcessorSupplier.of(tokenProcessor);
        String host = tokenProcessor.getDataCloudToken().getTenantUrl();
        Object builder = ManagedChannelBuilder.forAddress(host, 443).intercept(TracingHeadersInterceptor.of());
        DataspaceClient dataspaceClient = new DataspaceClient(properties, tokenProcessor);
        return DataCloudConnection.of(builder, properties, authInterceptor, tokenProcessor::getLakehouse, dataspaceClient, connectionString);
    }

    static void addClientUsernameIfRequired(Properties properties) {
        if (properties.containsKey("user")) {
            properties.computeIfAbsent("userName", (Function<? super Object, ?>)((Function<Object, Object>)p -> properties.get("user")));
        }
    }

    static {
        try {
            log.info("Registering DataCloud JDBC driver. info={}, classLoader={}", (Object)DriverVersion.formatDriverInfo(), (Object)DataCloudJDBCDriver.class.getClassLoader());
            DataCloudJDBCDriver.register();
            log.info("DataCloud JDBC driver registered");
        }
        catch (SQLException e) {
            log.error("Error occurred while registering DataCloud JDBC driver. {}", (Object)e.getMessage());
            throw new ExceptionInInitializerError(e);
        }
    }
}

