/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.model.DataCloudTokenResponse;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.Require;
import com.salesforce.datacloud.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Calendar;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudToken {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudToken.class);
    public static final String FAILED_LOGIN = "Failed to login. Please check credentials";
    private static final int JWT_PAYLOAD_INDEX = 1;
    private static final String JWT_DELIMITER = "\\.";
    private static final String AUDIENCE_TENANT_ID = "audienceTenantId";
    private final String type;
    private final String token;
    private final URI tenant;
    private final Calendar expiresIn;
    private static final String TENANT_IO_ERROR_RESPONSE = "Error while decoding tenantId.";

    public static DataCloudToken of(DataCloudTokenResponse model) throws SQLException {
        String type = model.getTokenType();
        String token = model.getToken();
        String tenantUrl = model.getInstanceUrl();
        Require.requireNotNullOrBlank(type, "token_type");
        Require.requireNotNullOrBlank(token, "access_token");
        Require.requireNotNullOrBlank(tenantUrl, "instance_url");
        Calendar expiresIn = Calendar.getInstance();
        expiresIn.add(13, model.getExpiresIn());
        try {
            URI tenant = URI.create(tenantUrl);
            return new DataCloudToken(type, token, tenant, expiresIn);
        }
        catch (IllegalArgumentException ex) {
            IllegalArgumentException rootCauseException = new IllegalArgumentException("Failed to parse the provided tenantUrl: '" + tenantUrl + "'. " + ex.getMessage(), ex.getCause());
            throw new DataCloudJDBCException(FAILED_LOGIN, "28000", rootCauseException);
        }
    }

    public boolean isAlive() {
        Calendar now = Calendar.getInstance();
        return now.compareTo(this.expiresIn) <= 0;
    }

    public String getTenantUrl() {
        return this.tenant.toString();
    }

    public String getTenantId() throws SQLException {
        return DataCloudToken.getTenantId(this.token);
    }

    public String getAccessToken() {
        return this.type + " " + this.token;
    }

    private static String getTenantId(String token) throws SQLException {
        String[] chunks = token.split(JWT_DELIMITER, -1);
        Base64.Decoder decoder = Base64.getUrlDecoder();
        try {
            String chunk = chunks[1];
            byte[] decodedChunk = decoder.decode(chunk);
            return new ObjectMapper().readTree(decodedChunk).get(AUDIENCE_TENANT_ID).asText();
        }
        catch (IOException e) {
            throw new DataCloudJDBCException(TENANT_IO_ERROR_RESPONSE, "58030", e);
        }
    }

    @Generated
    private DataCloudToken(String type, String token, URI tenant, Calendar expiresIn) {
        this.type = type;
        this.token = token;
        this.tenant = tenant;
        this.expiresIn = expiresIn;
    }
}

