/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.AuthenticationStrategy;
import com.salesforce.datacloud.jdbc.auth.DataCloudToken;
import com.salesforce.datacloud.jdbc.auth.ExchangeTokenAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.auth.OAuthToken;
import com.salesforce.datacloud.jdbc.auth.TokenCache;
import com.salesforce.datacloud.jdbc.auth.TokenCacheImpl;
import com.salesforce.datacloud.jdbc.auth.TokenProcessor;
import com.salesforce.datacloud.jdbc.auth.errors.AuthorizationException;
import com.salesforce.datacloud.jdbc.auth.model.AuthenticationResponseWithError;
import com.salesforce.datacloud.jdbc.auth.model.DataCloudTokenResponse;
import com.salesforce.datacloud.jdbc.auth.model.OAuthTokenResponse;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.ClientBuilder;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.datacloud.jdbc.util.StringCompatibility;
import com.salesforce.datacloud.shaded.com.google.common.base.Strings;
import com.salesforce.datacloud.shaded.dev.failsafe.Failsafe;
import com.salesforce.datacloud.shaded.dev.failsafe.FailsafeException;
import com.salesforce.datacloud.shaded.dev.failsafe.Policy;
import com.salesforce.datacloud.shaded.dev.failsafe.RetryPolicy;
import com.salesforce.datacloud.shaded.dev.failsafe.RetryPolicyBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedSupplier;
import com.salesforce.datacloud.shaded.okhttp3.OkHttpClient;
import java.sql.SQLException;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudTokenProcessor
implements TokenProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudTokenProcessor.class);
    static final String MAX_RETRIES_KEY = "maxRetries";
    static final int DEFAULT_MAX_RETRIES = 3;
    private static final String CORE_ERROR_RESPONSE = "Received an error when acquiring oauth access token";
    private static final String OFF_CORE_ERROR_RESPONSE = "Received an error when exchanging oauth access token for data cloud token";
    private AuthenticationSettings settings;
    private AuthenticationStrategy strategy;
    private OkHttpClient client;
    private TokenCache cache;
    private RetryPolicy<AuthenticationResponseWithError> policy;
    private RetryPolicy<AuthenticationResponseWithError> exponentialBackOffPolicy;

    private AuthenticationResponseWithError getTokenWithRetry(CheckedSupplier<AuthenticationResponseWithError> response) throws SQLException {
        try {
            return Failsafe.with(this.policy, (Policy[])new RetryPolicy[0]).get(response);
        }
        catch (FailsafeException ex) {
            if (ex.getCause() != null) {
                throw new DataCloudJDBCException(ex.getCause().getMessage(), "28000", ex);
            }
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    private AuthenticationResponseWithError getDataCloudTokenWithRetry(CheckedSupplier<AuthenticationResponseWithError> response) throws SQLException {
        try {
            return Failsafe.with(this.exponentialBackOffPolicy, (Policy[])new RetryPolicy[0]).get(response);
        }
        catch (FailsafeException ex) {
            if (ex.getCause() != null) {
                throw new DataCloudJDBCException(ex.getCause().getMessage(), "28000", ex);
            }
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    private OAuthToken fetchOAuthToken() throws SQLException {
        FormCommand command = this.strategy.buildAuthenticate();
        OAuthTokenResponse model = (OAuthTokenResponse)this.getTokenWithRetry(() -> {
            OAuthTokenResponse response = FormCommand.post(this.client, command, OAuthTokenResponse.class);
            return DataCloudTokenProcessor.throwExceptionOnError(response, CORE_ERROR_RESPONSE);
        });
        return OAuthToken.of(model);
    }

    private DataCloudToken fetchDataCloudToken() throws SQLException {
        DataCloudTokenResponse model = (DataCloudTokenResponse)this.getDataCloudTokenWithRetry(() -> {
            OAuthToken oauthToken = this.getOAuthToken();
            FormCommand command = ExchangeTokenAuthenticationStrategy.of(this.settings, oauthToken).toCommand();
            DataCloudTokenResponse response = FormCommand.post(this.client, command, DataCloudTokenResponse.class);
            return DataCloudTokenProcessor.throwExceptionOnError(response, OFF_CORE_ERROR_RESPONSE);
        });
        return DataCloudToken.of(model);
    }

    @Override
    public OAuthToken getOAuthToken() throws SQLException {
        try {
            return this.fetchOAuthToken();
        }
        catch (Exception ex) {
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    @Override
    public DataCloudToken getDataCloudToken() throws SQLException {
        DataCloudToken cachedDataCloudToken = this.cache.getDataCloudToken();
        if (cachedDataCloudToken != null && cachedDataCloudToken.isAlive()) {
            return cachedDataCloudToken;
        }
        try {
            return this.retrieveAndCacheDataCloudToken();
        }
        catch (Exception ex) {
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    @Override
    public String getLakehouse() throws SQLException {
        String tenantId = this.getDataCloudToken().getTenantId();
        String dataspace = this.getSettings().getDataspace();
        String response = "lakehouse:" + tenantId + ";" + Optional.ofNullable(dataspace).orElse("");
        log.info("Lakehouse: {}", (Object)response);
        return response;
    }

    private DataCloudToken retrieveAndCacheDataCloudToken() throws SQLException {
        try {
            DataCloudToken dataCloudToken = this.fetchDataCloudToken();
            this.cache.setDataCloudToken(dataCloudToken);
            return dataCloudToken;
        }
        catch (Exception ex) {
            this.cache.clearDataCloudToken();
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    private static AuthenticationResponseWithError throwExceptionOnError(AuthenticationResponseWithError response, String message) throws SQLException {
        String token = response.getToken();
        String code = response.getErrorCode();
        String description = response.getErrorDescription();
        if (StringCompatibility.isNotEmpty(token) && StringCompatibility.isNotEmpty(code) && StringCompatibility.isNotEmpty(description)) {
            log.warn("{} but got error code {} : {}", message, code, description);
        } else {
            if (StringCompatibility.isNotEmpty(code) || StringCompatibility.isNotEmpty(description)) {
                AuthorizationException authorizationException = AuthorizationException.builder().message(message + ". " + code + ": " + description).errorCode(code).errorDescription(description).build();
                throw new DataCloudJDBCException(authorizationException.getMessage(), "28000", authorizationException);
            }
            if (Strings.isNullOrEmpty(token)) {
                throw new DataCloudJDBCException(message + ", no token in response.", "28000");
            }
        }
        return response;
    }

    public static DataCloudTokenProcessor of(Properties properties) throws DataCloudJDBCException {
        AuthenticationSettings settings = AuthenticationSettings.of(properties);
        AuthenticationStrategy strategy = AuthenticationStrategy.of(settings);
        OkHttpClient client = ClientBuilder.buildOkHttpClient(properties);
        RetryPolicy<AuthenticationResponseWithError> policy = DataCloudTokenProcessor.buildRetryPolicy(properties);
        RetryPolicy<AuthenticationResponseWithError> exponentialBackOffPolicy = DataCloudTokenProcessor.buildExponentialBackoffRetryPolicy(properties);
        TokenCacheImpl cache = new TokenCacheImpl();
        return DataCloudTokenProcessor.builder().client(client).policy(policy).exponentialBackOffPolicy(exponentialBackOffPolicy).cache(cache).strategy(strategy).settings(settings).build();
    }

    static RetryPolicy<AuthenticationResponseWithError> buildRetryPolicy(Properties properties) {
        Integer maxRetries = PropertiesExtensions.getIntegerOrDefault(properties, MAX_RETRIES_KEY, 3);
        return ((RetryPolicyBuilder)RetryPolicy.builder().withMaxRetries(maxRetries).handleIf(e -> !(e instanceof AuthorizationException))).build();
    }

    static RetryPolicy<AuthenticationResponseWithError> buildExponentialBackoffRetryPolicy(Properties properties) {
        Integer maxRetries = PropertiesExtensions.getIntegerOrDefault(properties, MAX_RETRIES_KEY, 3);
        return ((RetryPolicyBuilder)RetryPolicy.builder().withMaxRetries(maxRetries).withBackoff(1L, 30L, ChronoUnit.SECONDS).handleIf(e -> !(e instanceof AuthorizationException))).build();
    }

    @Generated
    DataCloudTokenProcessor(AuthenticationSettings settings, AuthenticationStrategy strategy, OkHttpClient client, TokenCache cache, RetryPolicy<AuthenticationResponseWithError> policy, RetryPolicy<AuthenticationResponseWithError> exponentialBackOffPolicy) {
        this.settings = settings;
        this.strategy = strategy;
        this.client = client;
        this.cache = cache;
        this.policy = policy;
        this.exponentialBackOffPolicy = exponentialBackOffPolicy;
    }

    @Generated
    private static DataCloudTokenProcessorBuilder builder() {
        return new DataCloudTokenProcessorBuilder();
    }

    @Override
    @Generated
    public AuthenticationSettings getSettings() {
        return this.settings;
    }

    @Generated
    private static class DataCloudTokenProcessorBuilder {
        @Generated
        private AuthenticationSettings settings;
        @Generated
        private AuthenticationStrategy strategy;
        @Generated
        private OkHttpClient client;
        @Generated
        private TokenCache cache;
        @Generated
        private RetryPolicy<AuthenticationResponseWithError> policy;
        @Generated
        private RetryPolicy<AuthenticationResponseWithError> exponentialBackOffPolicy;

        @Generated
        DataCloudTokenProcessorBuilder() {
        }

        @Generated
        private DataCloudTokenProcessorBuilder settings(AuthenticationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        private DataCloudTokenProcessorBuilder strategy(AuthenticationStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Generated
        private DataCloudTokenProcessorBuilder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        @Generated
        private DataCloudTokenProcessorBuilder cache(TokenCache cache) {
            this.cache = cache;
            return this;
        }

        @Generated
        private DataCloudTokenProcessorBuilder policy(RetryPolicy<AuthenticationResponseWithError> policy) {
            this.policy = policy;
            return this;
        }

        @Generated
        private DataCloudTokenProcessorBuilder exponentialBackOffPolicy(RetryPolicy<AuthenticationResponseWithError> exponentialBackOffPolicy) {
            this.exponentialBackOffPolicy = exponentialBackOffPolicy;
            return this;
        }

        @Generated
        private DataCloudTokenProcessor build() {
            return new DataCloudTokenProcessor(this.settings, this.strategy, this.client, this.cache, this.policy, this.exponentialBackOffPolicy);
        }

        @Generated
        public String toString() {
            return "DataCloudTokenProcessor.DataCloudTokenProcessorBuilder(settings=" + this.settings + ", strategy=" + this.strategy + ", client=" + this.client + ", cache=" + this.cache + ", policy=" + this.policy + ", exponentialBackOffPolicy=" + this.exponentialBackOffPolicy + ")";
        }
    }
}

