/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.model.OAuthTokenResponse;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.sql.SQLException;
import lombok.Generated;

public final class OAuthToken {
    public static final String FAILED_LOGIN = "Failed to login. Please check credentials";
    private static final String BEARER_PREFIX = "Bearer ";
    private final String token;
    private final URI instanceUrl;

    public static OAuthToken of(OAuthTokenResponse response) throws SQLException {
        String accessToken = response.getToken();
        if (StringUtils.isBlank(accessToken)) {
            throw new DataCloudJDBCException(FAILED_LOGIN, "28000");
        }
        try {
            URI instanceUrl = new URI(response.getInstanceUrl());
            return OAuthToken.builder().token(accessToken).instanceUrl(instanceUrl).build();
        }
        catch (Exception ex) {
            throw new DataCloudJDBCException(FAILED_LOGIN, "28000", ex);
        }
    }

    public String getBearerToken() {
        return BEARER_PREFIX + this.getToken();
    }

    @Generated
    OAuthToken(String token, URI instanceUrl) {
        this.token = token;
        this.instanceUrl = instanceUrl;
    }

    @Generated
    private static OAuthTokenBuilder builder() {
        return new OAuthTokenBuilder();
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public URI getInstanceUrl() {
        return this.instanceUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken other = (OAuthToken)o;
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        URI this$instanceUrl = this.getInstanceUrl();
        URI other$instanceUrl = other.getInstanceUrl();
        return !(this$instanceUrl == null ? other$instanceUrl != null : !((Object)this$instanceUrl).equals(other$instanceUrl));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        URI $instanceUrl = this.getInstanceUrl();
        result = result * 59 + ($instanceUrl == null ? 43 : ((Object)$instanceUrl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OAuthToken(token=" + this.getToken() + ", instanceUrl=" + this.getInstanceUrl() + ")";
    }

    @Generated
    private static class OAuthTokenBuilder {
        @Generated
        private String token;
        @Generated
        private URI instanceUrl;

        @Generated
        OAuthTokenBuilder() {
        }

        @Generated
        private OAuthTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        private OAuthTokenBuilder instanceUrl(URI instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        @Generated
        private OAuthToken build() {
            return new OAuthToken(this.token, this.instanceUrl);
        }

        @Generated
        public String toString() {
            return "OAuthToken.OAuthTokenBuilder(token=" + this.token + ", instanceUrl=" + this.instanceUrl + ")";
        }
    }
}

