/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.config;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceReader.class);
    private static final String NOT_FOUND_MESSAGE = "Resource file not found";
    private static final String IO_EXCEPTION_MESSAGE = "Error while loading resource file";

    public static String readResourceAsString(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        AtomicReference result = new AtomicReference();
        ResourceReader.withResourceAsStream(path, in -> result.set(new String(ByteStreams.toByteArray(in), StandardCharsets.UTF_8)));
        return (String)result.get();
    }

    public static Properties readResourceAsProperties(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        Properties result = new Properties();
        ResourceReader.withResourceAsStream(path, result::load);
        return result;
    }

    static void withResourceAsStream(String path, @NonNull IOExceptionThrowingConsumer<InputStream> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer is marked non-null but is null");
        }
        try (InputStream in = ResourceReader.class.getResourceAsStream(path);){
            if (in == null) {
                String message = String.format("%s. path=%s", NOT_FOUND_MESSAGE, path);
                throw new DataCloudJDBCException(message, "58P01");
            }
            consumer.accept(in);
        }
        catch (IOException e) {
            String message = String.format("%s. path=%s", IO_EXCEPTION_MESSAGE, path);
            log.error(message, e);
            throw new DataCloudJDBCException(message, "58P01", e);
        }
    }

    public static List<String> readResourceAsStringList(String path) {
        return Arrays.stream(ResourceReader.readResourceAsString(path).split("\n")).map(String::trim).collect(Collectors.toList());
    }

    @Generated
    private ResourceReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface IOExceptionThrowingConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

