/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.config.QueryResources;
import com.salesforce.datacloud.jdbc.core.MetadataResultSet;
import com.salesforce.datacloud.jdbc.core.QueryDBMetadata;
import com.salesforce.datacloud.jdbc.core.QueryResultSetMetadata;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import com.salesforce.datacloud.jdbc.util.StringCompatibility;
import com.salesforce.datacloud.jdbc.util.ThrowingJdbcSupplier;
import com.salesforce.datacloud.shaded.com.google.common.base.Strings;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableList;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableMap;
import com.salesforce.datacloud.shaded.com.google.common.collect.Maps;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.Meta;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.QueryState;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.SqlType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryMetadataUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryMetadataUtil.class);
    static final int NUM_TABLE_METADATA_COLUMNS = 10;
    static final int NUM_COLUMN_METADATA_COLUMNS = 24;
    static final int NUM_SCHEMA_METADATA_COLUMNS = 2;
    static final int NUM_TABLE_TYPES_METADATA_COLUMNS = 1;
    static final int NUM_CATALOG_METADATA_COLUMNS = 1;
    private static final int TABLE_CATALOG_INDEX = 0;
    private static final int TABLE_SCHEMA_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;
    private static final int COLUMN_NAME_INDEX = 3;
    private static final int DATA_TYPE_INDEX = 4;
    private static final int TYPE_NAME_INDEX = 5;
    private static final int COLUMN_SIZE_INDEX = 6;
    private static final int BUFFER_LENGTH_INDEX = 7;
    private static final int DECIMAL_DIGITS_INDEX = 8;
    private static final int NUM_PREC_RADIX_INDEX = 9;
    private static final int NULLABLE_INDEX = 10;
    private static final int DESCRIPTION_INDEX = 11;
    private static final int COLUMN_DEFAULT_INDEX = 12;
    private static final int SQL_DATA_TYPE_INDEX = 13;
    private static final int SQL_DATE_TIME_SUB_INDEX = 14;
    private static final int CHAR_OCTET_LENGTH_INDEX = 15;
    private static final int ORDINAL_POSITION_INDEX = 16;
    private static final int IS_NULLABLE_INDEX = 17;
    private static final int SCOPE_CATALOG_INDEX = 18;
    private static final int SCOPE_SCHEMA_INDEX = 19;
    private static final int SCOPE_TABLE_INDEX = 20;
    private static final int SOURCE_DATA_TYPE_INDEX = 21;
    private static final int AUTO_INCREMENT_INDEX = 22;
    private static final int GENERATED_COLUMN_INDEX = 23;
    private static final Map<String, String> dbTypeToSql = ImmutableMap.ofEntries(Maps.immutableEntry("int2", SqlType.SMALLINT.toString()), Maps.immutableEntry("int4", SqlType.INTEGER.toString()), Maps.immutableEntry("oid", SqlType.BIGINT.toString()), Maps.immutableEntry("int8", SqlType.BIGINT.toString()), Maps.immutableEntry("float", SqlType.DOUBLE.toString()), Maps.immutableEntry("float4", SqlType.REAL.toString()), Maps.immutableEntry("float8", SqlType.DOUBLE.toString()), Maps.immutableEntry("bool", SqlType.BOOLEAN.toString()), Maps.immutableEntry("char", SqlType.CHAR.toString()), Maps.immutableEntry("text", SqlType.VARCHAR.toString()), Maps.immutableEntry("date", SqlType.DATE.toString()), Maps.immutableEntry("time", SqlType.TIME.toString()), Maps.immutableEntry("timetz", SqlType.TIME.toString()), Maps.immutableEntry("timestamp", SqlType.TIMESTAMP.toString()), Maps.immutableEntry("timestamptz", SqlType.TIMESTAMP.toString()), Maps.immutableEntry("array", SqlType.ARRAY.toString()));
    private static final Map<String, Map<String, String>> tableTypeClauses = ImmutableMap.ofEntries(Maps.immutableEntry("TABLE", ImmutableMap.of("SCHEMAS", "c.relkind = 'r' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'r' AND c.relname !~ '^pg_'")), Maps.immutableEntry("PARTITIONED TABLE", ImmutableMap.of("SCHEMAS", "c.relkind = 'p' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'p' AND c.relname !~ '^pg_'")), Maps.immutableEntry("VIEW", ImmutableMap.of("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'")), Maps.immutableEntry("INDEX", ImmutableMap.of("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'")), Maps.immutableEntry("PARTITIONED INDEX", ImmutableMap.of("SCHEMAS", "c.relkind = 'I' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'I' AND c.relname !~ '^pg_'")), Maps.immutableEntry("SEQUENCE", ImmutableMap.of("SCHEMAS", "c.relkind = 'S'", "NOSCHEMAS", "c.relkind = 'S'")), Maps.immutableEntry("TYPE", ImmutableMap.of("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'")), Maps.immutableEntry("SYSTEM TABLE", ImmutableMap.of("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')", "NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'")), Maps.immutableEntry("SYSTEM TOAST TABLE", ImmutableMap.of("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'", "NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'")), Maps.immutableEntry("SYSTEM TOAST INDEX", ImmutableMap.of("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'", "NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'")), Maps.immutableEntry("SYSTEM VIEW", ImmutableMap.of("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'")), Maps.immutableEntry("SYSTEM INDEX", ImmutableMap.of("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'")), Maps.immutableEntry("TEMPORARY TABLE", ImmutableMap.of("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ")), Maps.immutableEntry("TEMPORARY INDEX", ImmutableMap.of("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ")), Maps.immutableEntry("TEMPORARY VIEW", ImmutableMap.of("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ")), Maps.immutableEntry("TEMPORARY SEQUENCE", ImmutableMap.of("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ")), Maps.immutableEntry("FOREIGN TABLE", ImmutableMap.of("SCHEMAS", "c.relkind = 'f'", "NOSCHEMAS", "c.relkind = 'f'")), Maps.immutableEntry("MATERIALIZED VIEW", ImmutableMap.of("SCHEMAS", "c.relkind = 'm'", "NOSCHEMAS", "c.relkind = 'm'")));

    public static ResultSet createTableResultSet(String schemaPattern, String tableNamePattern, String[] types, Connection connection) throws SQLException {
        List<Object> data;
        try (Statement statement = connection.createStatement();){
            String tablesQuery = QueryMetadataUtil.getTablesQuery(schemaPattern, tableNamePattern, types);
            ResultSet resultSet = statement.executeQuery(tablesQuery);
            data = QueryMetadataUtil.constructTableData(resultSet);
        }
        return QueryMetadataUtil.getMetadataResultSet(QueryDBMetadata.GET_TABLES, 10, data);
    }

    static AvaticaResultSet getMetadataResultSet(QueryDBMetadata queryDbMetadata, int columnsCount, List<Object> data) throws SQLException {
        QueryResultSetMetadata queryResultSetMetadata = new QueryResultSetMetadata(queryDbMetadata);
        List<ColumnMetaData> columnMetaData = ArrowUtils.convertJDBCMetadataToAvaticaColumns(queryResultSetMetadata, columnsCount);
        Meta.Signature signature = new Meta.Signature(columnMetaData, null, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
        return MetadataResultSet.of(null, new QueryState(), signature, queryResultSetMetadata, TimeZone.getDefault(), null, data);
    }

    private static List<Object> constructTableData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                List<Object> rowData = Arrays.asList(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), "TABLE", resultSet.getString("REMARKS"), resultSet.getString("TYPE_CAT"), resultSet.getString("TYPE_SCHEM"), resultSet.getString("TYPE_NAME"), resultSet.getString("SELF_REFERENCING_COL_NAME"), resultSet.getString("REF_GENERATION"));
                data.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    private static String getTablesQuery(String schemaPattern, String tableNamePattern, String[] types) {
        String tablesQuery = QueryResources.getTablesQuery();
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            tablesQuery = tablesQuery + " AND n.nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            tablesQuery = tablesQuery + " AND c.relname LIKE " + QueryMetadataUtil.quoteStringLiteral(tableNamePattern);
        }
        if (types != null && types.length > 0) {
            tablesQuery = tablesQuery + " AND (false ";
            StringBuilder orclause = new StringBuilder();
            for (String type : types) {
                Map<String, String> clauses = tableTypeClauses.get(type);
                if (clauses == null) continue;
                String clause = clauses.get("SCHEMAS");
                orclause.append(" OR ( ").append(clause).append(" ) ");
            }
            tablesQuery = tablesQuery + orclause.toString() + ") ";
        }
        tablesQuery = tablesQuery + " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        return tablesQuery;
    }

    public static ResultSet createColumnResultSet(String schemaPattern, String tableNamePattern, String columnNamePattern, Connection connection) throws SQLException {
        List<Object> data;
        try (Statement statement = connection.createStatement();){
            String getColumnsQuery = QueryMetadataUtil.getColumnsQuery(schemaPattern, tableNamePattern, columnNamePattern);
            ResultSet resultSet = statement.executeQuery(getColumnsQuery);
            data = QueryMetadataUtil.constructColumnData(resultSet);
        }
        return QueryMetadataUtil.getMetadataResultSet(QueryDBMetadata.GET_COLUMNS, 24, data);
    }

    private static String getColumnsQuery(String schemaPattern, String tableNamePattern, String columnNamePattern) {
        String getColumnsQuery = QueryResources.getColumnsQuery();
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            getColumnsQuery = getColumnsQuery + " AND n.nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            getColumnsQuery = getColumnsQuery + " AND c.relname LIKE " + QueryMetadataUtil.quoteStringLiteral(tableNamePattern);
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            getColumnsQuery = getColumnsQuery + " AND attname LIKE " + QueryMetadataUtil.quoteStringLiteral(columnNamePattern);
        }
        getColumnsQuery = getColumnsQuery + " ORDER BY nspname, c.relname, attnum ";
        return getColumnsQuery;
    }

    private static List<Object> constructColumnData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                Object[] rowData = new Object[24];
                Object tableCatalog = null;
                rowData[0] = tableCatalog;
                String tableSchema = resultSet.getString("nspname");
                rowData[1] = tableSchema;
                String tableName = resultSet.getString("relname");
                rowData[2] = tableName;
                String columnName = resultSet.getString("attname");
                rowData[3] = columnName;
                int dataType = (int)resultSet.getLong("atttypid");
                rowData[4] = dataType;
                String typeName = resultSet.getString("datatype");
                String string = typeName = typeName == null ? "" : typeName;
                if (typeName.toLowerCase().contains("numeric")) {
                    rowData[5] = SqlType.NUMERIC.toString();
                    rowData[4] = SqlType.valueOf((String)SqlType.NUMERIC.toString()).id;
                } else {
                    rowData[5] = dbTypeToSql.getOrDefault(typeName.toLowerCase(), typeName);
                    dataType = dbTypeToSql.containsKey(typeName.toLowerCase()) ? SqlType.valueOf((String)QueryMetadataUtil.dbTypeToSql.get((Object)typeName.toLowerCase())).id : (int)resultSet.getLong("atttypid");
                    rowData[4] = dataType;
                }
                int columnSize = 255;
                rowData[6] = columnSize;
                int decimalDigits = 2;
                rowData[8] = decimalDigits;
                int numPrecRadix = 10;
                rowData[9] = numPrecRadix;
                int nullable = resultSet.getBoolean("attnotnull") ? 0 : 1;
                rowData[10] = nullable;
                String description = resultSet.getString("description");
                rowData[11] = description;
                String columnDefault = resultSet.getString("adsrc");
                rowData[12] = columnDefault;
                rowData[13] = null;
                String sqlDateTimeSub = "";
                rowData[14] = sqlDateTimeSub;
                int charOctetLength = 2;
                rowData[15] = charOctetLength;
                int ordinalPosition = resultSet.getInt("attnum");
                rowData[16] = ordinalPosition;
                String isNullable = resultSet.getBoolean("attnotnull") ? "NO" : "YES";
                rowData[17] = isNullable;
                rowData[18] = null;
                rowData[19] = null;
                rowData[20] = null;
                rowData[21] = null;
                String identity = resultSet.getString("attidentity");
                String defval = resultSet.getString("adsrc");
                String autoIncrement = "NO";
                if (defval != null && defval.contains("nextval(") || identity != null) {
                    autoIncrement = "YES";
                }
                rowData[22] = autoIncrement;
                String generated = resultSet.getString("attgenerated");
                String generatedColumn = generated != null ? "YES" : "NO";
                rowData[23] = generatedColumn;
                data.add(Arrays.asList(rowData));
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    public static ResultSet createSchemaResultSet(String schemaPattern, Connection connection) throws SQLException {
        List<Object> data;
        try (Statement statement = connection.createStatement();){
            String schemasQuery = QueryMetadataUtil.getSchemasQuery(schemaPattern);
            ResultSet resultSet = statement.executeQuery(schemasQuery);
            data = QueryMetadataUtil.constructSchemaData(resultSet);
        }
        return QueryMetadataUtil.getMetadataResultSet(QueryDBMetadata.GET_SCHEMAS, 2, data);
    }

    private static String getSchemasQuery(String schemaPattern) {
        String schemasQuery = QueryResources.getSchemasQuery();
        if (StringCompatibility.isNotEmpty(schemaPattern)) {
            schemasQuery = schemasQuery + " AND nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        return schemasQuery;
    }

    private static List<Object> constructSchemaData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                List<Object> rowData = Arrays.asList(resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_CATALOG"));
                data.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    public static ResultSet createTableTypesResultSet() throws SQLException {
        List<Object> data = QueryMetadataUtil.constructTableTypesData();
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_TABLE_TYPES;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 1, data);
    }

    private static List<Object> constructTableTypesData() {
        ArrayList<Object> data = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, String>> entry : tableTypeClauses.entrySet()) {
            List<Object> rowData = Arrays.asList(entry.getValue());
            data.add(rowData);
        }
        return data;
    }

    static List<Object> getLakehouse(ThrowingJdbcSupplier<String> lakehouseSupplier) throws SQLException {
        if (lakehouseSupplier == null) {
            return ImmutableList.of();
        }
        String lakehouse = lakehouseSupplier.get();
        if (Strings.isNullOrEmpty(lakehouse)) {
            return ImmutableList.of();
        }
        return ImmutableList.of(ImmutableList.of(lakehouse));
    }

    public static ResultSet createCatalogsResultSet(ThrowingJdbcSupplier<String> lakehouseSupplier) throws SQLException {
        List<Object> data = QueryMetadataUtil.getLakehouse(lakehouseSupplier);
        return QueryMetadataUtil.getMetadataResultSet(QueryDBMetadata.GET_CATALOGS, 1, data);
    }

    public static String quoteStringLiteral(String v) {
        StringBuilder result = new StringBuilder();
        result.ensureCapacity(v.length() + 8);
        result.append("E'");
        boolean escaped = false;
        block9: for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            switch (ch) {
                case '\'': {
                    result.append("''");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    escaped = true;
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    escaped = true;
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    escaped = true;
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    escaped = true;
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    escaped = true;
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    escaped = true;
                    continue block9;
                }
                default: {
                    if (ch < ' ') {
                        result.append('\\').append(String.format("%03o", ch));
                        escaped = true;
                        continue block9;
                    }
                    result.append(ch);
                }
            }
        }
        if (!escaped) {
            result.deleteCharAt(0);
        }
        return result.append('\'').toString();
    }

    @Generated
    private QueryMetadataUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

