/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.QueryDBMetadata;
import java.sql.ResultSetMetaData;
import java.util.List;

public class QueryResultSetMetadata
implements ResultSetMetaData {
    private final List<String> columnNames;
    private final List<String> columnTypes;
    private final List<Integer> columnTypeIds;

    public QueryResultSetMetadata(List<String> columnNames, List<String> columnTypes, List<Integer> columnTypeIds) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnTypeIds = columnTypeIds;
    }

    public QueryResultSetMetadata(QueryDBMetadata metadata) {
        this.columnNames = metadata.getColumnNames();
        this.columnTypes = metadata.getColumnTypes();
        this.columnTypeIds = metadata.getColumnTypeIds();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 1;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        int columnType = this.getColumnType(column);
        switch (columnType) {
            case -2: 
            case 1: 
            case 12: {
                return this.getColumnName(column).length();
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return this.getPrecision(column) + 1;
            }
            case 3: {
                return this.getPrecision(column) + 1 + 1;
            }
            case 8: {
                return 24;
            }
            case 16: {
                return 5;
            }
        }
        return 25;
    }

    @Override
    public String getColumnLabel(int column) {
        if (this.columnNames == null || column > this.columnNames.size()) {
            return "C" + (column - 1);
        }
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public int getPrecision(int column) {
        int columnType = this.getColumnType(column);
        switch (columnType) {
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return this.getColumnName(column).length();
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 38;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) {
        int columnType = this.getColumnType(column);
        switch (columnType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 18;
            }
        }
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) {
        return this.columnTypeIds.get(column - 1);
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.columnTypes.get(column - 1);
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }
}

