/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.ArrowStreamReaderCursor;
import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.ExecuteQueryResponseChannel;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.datacloud.query.v3.DataCloudQueryStatus;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.BufferAllocator;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.RootAllocator;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ipc.ArrowStreamReader;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.Meta;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.QueryState;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.QueryResult;

public class StreamingResultSet
extends AvaticaResultSet
implements DataCloudResultSet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingResultSet.class);
    private static final int ROOT_ALLOCATOR_MB_FROM_V2 = 0x6400000;
    private final HyperGrpcClientExecutor client;
    private final ArrowStreamReaderCursor cursor;
    private final String queryId;
    private static final String QUERY_FAILURE = "Failed to execute query: ";

    private StreamingResultSet(HyperGrpcClientExecutor client, ArrowStreamReaderCursor cursor, String queryId, AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.client = client;
        this.cursor = cursor;
        this.queryId = queryId;
    }

    public static StreamingResultSet of(String queryId, HyperGrpcClientExecutor client, Iterator<QueryResult> iterator2) {
        try {
            ExecuteQueryResponseChannel channel = ExecuteQueryResponseChannel.of(StreamUtilities.toStream(iterator2));
            ArrowStreamReader reader = new ArrowStreamReader(channel, (BufferAllocator)new RootAllocator(0x6400000L));
            VectorSchemaRoot schemaRoot = reader.getVectorSchemaRoot();
            List<ColumnMetaData> columns = ArrowUtils.toColumnMetaData(schemaRoot.getSchema().getFields());
            TimeZone timezone = TimeZone.getDefault();
            QueryState state = new QueryState();
            Meta.Signature signature = new Meta.Signature(columns, null, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
            AvaticaResultSetMetaData metadata = new AvaticaResultSetMetaData(null, null, signature);
            ArrowStreamReaderCursor cursor = new ArrowStreamReaderCursor(reader);
            StreamingResultSet result = new StreamingResultSet(client, cursor, queryId, null, state, signature, metadata, timezone, null);
            result.execute2(cursor, columns);
            return result;
        }
        catch (Exception ex) {
            throw QueryExceptionHandler.createException(QUERY_FAILURE + queryId, ex);
        }
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public Stream<DataCloudQueryStatus> getQueryStatus() throws DataCloudJDBCException {
        if (this.client == null) {
            return Stream.empty();
        }
        return this.client.getQueryStatus(this.queryId);
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getRow() {
        return this.cursor.getRowsSeen();
    }
}

