/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BaseIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BigIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.IntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.SmallIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TinyIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.UInt4Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableBigIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableSmallIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTinyIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableUInt4Holder;
import java.sql.SQLException;
import lombok.Generated;

final class NumericGetter {
    private static final String INVALID_VECTOR_ERROR_RESPONSE = "Invalid Integer Vector provided";

    static Getter createGetter(BaseIntVector vector) throws SQLException {
        if (vector instanceof TinyIntVector) {
            return NumericGetter.createGetter((TinyIntVector)vector);
        }
        if (vector instanceof SmallIntVector) {
            return NumericGetter.createGetter((SmallIntVector)vector);
        }
        if (vector instanceof IntVector) {
            return NumericGetter.createGetter((IntVector)vector);
        }
        if (vector instanceof BigIntVector) {
            return NumericGetter.createGetter((BigIntVector)vector);
        }
        if (vector instanceof UInt4Vector) {
            return NumericGetter.createGetter((UInt4Vector)vector);
        }
        UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_VECTOR_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_VECTOR_ERROR_RESPONSE, "2200G", rootCauseException);
    }

    private static Getter createGetter(TinyIntVector vector) {
        NullableTinyIntHolder nullableTinyIntHolder = new NullableTinyIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableTinyIntHolder);
            holder.isSet = nullableTinyIntHolder.isSet;
            holder.value = nullableTinyIntHolder.value;
        };
    }

    private static Getter createGetter(SmallIntVector vector) {
        NullableSmallIntHolder nullableSmallIntHolder = new NullableSmallIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableSmallIntHolder);
            holder.isSet = nullableSmallIntHolder.isSet;
            holder.value = nullableSmallIntHolder.value;
        };
    }

    private static Getter createGetter(IntVector vector) {
        NullableIntHolder nullableIntHolder = new NullableIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableIntHolder);
            holder.isSet = nullableIntHolder.isSet;
            holder.value = nullableIntHolder.value;
        };
    }

    private static Getter createGetter(BigIntVector vector) {
        NullableBigIntHolder nullableBigIntHolder = new NullableBigIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableBigIntHolder);
            holder.isSet = nullableBigIntHolder.isSet;
            holder.value = nullableBigIntHolder.value;
        };
    }

    private static Getter createGetter(UInt4Vector vector) {
        NullableUInt4Holder nullableUInt4Holder = new NullableUInt4Holder();
        return (index, holder) -> {
            vector.get(index, nullableUInt4Holder);
            holder.isSet = nullableUInt4Holder.isSet;
            holder.value = nullableUInt4Holder.value;
        };
    }

    @Generated
    private NumericGetter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, NumericHolder var2);
    }

    static class NumericHolder {
        int isSet;
        long value;

        NumericHolder() {
        }
    }
}

