/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.LargeVarCharVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VarCharVector;
import java.nio.charset.StandardCharsets;
import java.util.function.IntSupplier;

public class VarCharVectorAccessor
extends QueryJDBCAccessor {
    private final Getter getter;

    public VarCharVectorAccessor(VarCharVector vector, IntSupplier currenRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        this(vector::get, currenRowSupplier, wasNullConsumer);
    }

    public VarCharVectorAccessor(LargeVarCharVector vector, IntSupplier currenRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        this(vector::get, currenRowSupplier, wasNullConsumer);
    }

    VarCharVectorAccessor(Getter getter, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(currentRowSupplier, wasNullConsumer);
        this.getter = getter;
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.getter.get(this.getCurrentRow());
        this.wasNull = bytes == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return this.getter.get(this.getCurrentRow());
    }

    @Override
    public String getString() {
        return this.getObject();
    }

    @Override
    public String getObject() {
        byte[] bytes = this.getBytes();
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @FunctionalInterface
    static interface Getter {
        public byte[] get(int var1);
    }
}

