/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.partial;

import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import salesforce.cdp.hyperdb.v1.QueryResult;

class RowBasedContext {
    @NonNull
    private final HyperGrpcClientExecutor client;
    @NonNull
    private final String queryId;
    private final long offset;
    private final long limit;
    private final AtomicLong seen = new AtomicLong(0L);

    public Iterator<QueryResult> getQueryResult(boolean omitSchema) throws DataCloudJDBCException {
        long currentOffset = this.offset + this.seen.get();
        long currentLimit = this.limit - this.seen.get();
        return this.client.getQueryResult(this.queryId, currentOffset, currentLimit, omitSchema);
    }

    @Generated
    RowBasedContext(@NonNull HyperGrpcClientExecutor client, @NonNull String queryId, long offset, long limit) {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        this.client = client;
        this.queryId = queryId;
        this.offset = offset;
        this.limit = limit;
    }

    @Generated
    public static RowBasedContextBuilder builder() {
        return new RowBasedContextBuilder();
    }

    @Generated
    public long getLimit() {
        return this.limit;
    }

    @Generated
    public AtomicLong getSeen() {
        return this.seen;
    }

    @Generated
    public static class RowBasedContextBuilder {
        @Generated
        private HyperGrpcClientExecutor client;
        @Generated
        private String queryId;
        @Generated
        private long offset;
        @Generated
        private long limit;

        @Generated
        RowBasedContextBuilder() {
        }

        @Generated
        public RowBasedContextBuilder client(@NonNull HyperGrpcClientExecutor client) {
            if (client == null) {
                throw new IllegalArgumentException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @Generated
        public RowBasedContextBuilder queryId(@NonNull String queryId) {
            if (queryId == null) {
                throw new IllegalArgumentException("queryId is marked non-null but is null");
            }
            this.queryId = queryId;
            return this;
        }

        @Generated
        public RowBasedContextBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public RowBasedContextBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public RowBasedContext build() {
            return new RowBasedContext(this.client, this.queryId, this.offset, this.limit);
        }

        @Generated
        public String toString() {
            return "RowBasedContext.RowBasedContextBuilder(client=" + this.client + ", queryId=" + this.queryId + ", offset=" + this.offset + ", limit=" + this.limit + ")";
        }
    }
}

