/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.partial;

import com.salesforce.datacloud.jdbc.core.partial.RowBased;
import com.salesforce.datacloud.jdbc.core.partial.RowBasedContext;
import java.util.Iterator;
import java.util.NoSuchElementException;
import lombok.Generated;
import salesforce.cdp.hyperdb.v1.QueryResult;

class RowBasedFullRange
implements RowBased {
    private final RowBasedContext context;
    private Iterator<QueryResult> iterator;

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.context.getQueryResult(false);
            return this.iterator.hasNext();
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        if (this.context.getSeen().get() < this.context.getLimit()) {
            this.iterator = this.context.getQueryResult(true);
        }
        return this.iterator.hasNext();
    }

    @Override
    public QueryResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QueryResult next = this.iterator.next();
        this.context.getSeen().addAndGet(next.getResultPartRowCount());
        return next;
    }

    @Generated
    RowBasedFullRange(RowBasedContext context, Iterator<QueryResult> iterator2) {
        this.context = context;
        this.iterator = iterator2;
    }

    @Generated
    public static RowBasedFullRangeBuilder builder() {
        return new RowBasedFullRangeBuilder();
    }

    @Generated
    public static class RowBasedFullRangeBuilder {
        @Generated
        private RowBasedContext context;
        @Generated
        private Iterator<QueryResult> iterator;

        @Generated
        RowBasedFullRangeBuilder() {
        }

        @Generated
        public RowBasedFullRangeBuilder context(RowBasedContext context) {
            this.context = context;
            return this;
        }

        @Generated
        public RowBasedFullRangeBuilder iterator(Iterator<QueryResult> iterator2) {
            this.iterator = iterator2;
            return this;
        }

        @Generated
        public RowBasedFullRange build() {
            return new RowBasedFullRange(this.context, this.iterator);
        }

        @Generated
        public String toString() {
            return "RowBasedFullRange.RowBasedFullRangeBuilder(context=" + this.context + ", iterator=" + this.iterator + ")";
        }
    }
}

