/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.exception;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.com.google.protobuf.Any;
import com.salesforce.datacloud.shaded.com.google.protobuf.InvalidProtocolBufferException;
import com.salesforce.datacloud.shaded.com.google.rpc.Status;
import com.salesforce.datacloud.shaded.io.grpc.StatusRuntimeException;
import com.salesforce.datacloud.shaded.io.grpc.protobuf.StatusProto;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.ErrorInfo;

public final class QueryExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryExceptionHandler.class);
    private static final int MAX_QUERY_LENGTH_IN_EXCEPTION = 16384;

    public static DataCloudJDBCException createQueryException(String query, Exception e) {
        String exceptionQuery = query.length() > 16384 ? query.substring(0, 16384) + "<truncated>" : query;
        return QueryExceptionHandler.createException("Failed to execute query: " + exceptionQuery, e);
    }

    public static DataCloudJDBCException createException(String message, Exception e) {
        List<Any> detailsList;
        Any firstError;
        StatusRuntimeException ex;
        Status status;
        if (e instanceof StatusRuntimeException && (status = StatusProto.fromThrowable(ex = (StatusRuntimeException)e)) != null && (firstError = (Any)(detailsList = status.getDetailsList()).stream().filter(any -> any.is(ErrorInfo.class)).findFirst().orElse(null)) != null) {
            ErrorInfo errorInfo;
            try {
                errorInfo = firstError.unpack(ErrorInfo.class);
            }
            catch (InvalidProtocolBufferException exc) {
                return new DataCloudJDBCException("Invalid error info", e);
            }
            String sqlState = errorInfo.getSqlstate();
            String customerHint = errorInfo.getCustomerHint();
            String customerDetail = errorInfo.getCustomerDetail();
            String primaryMessage = String.format("%s: %s%nDETAIL:%n%s%nHINT:%n%s", sqlState, errorInfo.getPrimaryMessage(), customerDetail, customerHint);
            return new DataCloudJDBCException(primaryMessage, sqlState, customerHint, customerDetail, ex);
        }
        return new DataCloudJDBCException(message, e);
    }

    public static SQLException createException(String message, String sqlState, Exception e) {
        return new SQLException(message, sqlState, e.getCause());
    }

    public static SQLException createException(String message, String sqlState) {
        return new SQLException(message, sqlState);
    }

    public static SQLException createException(String message) {
        return new DataCloudJDBCException(message);
    }

    @Generated
    private QueryExceptionHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

