/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.datacloud.shaded.com.google.common.cache.Cache;
import com.salesforce.datacloud.shaded.com.google.common.cache.CacheBuilder;
import com.salesforce.datacloud.shaded.okhttp3.Interceptor;
import com.salesforce.datacloud.shaded.okhttp3.MediaType;
import com.salesforce.datacloud.shaded.okhttp3.Protocol;
import com.salesforce.datacloud.shaded.okhttp3.Request;
import com.salesforce.datacloud.shaded.okhttp3.Response;
import com.salesforce.datacloud.shaded.okhttp3.ResponseBody;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCacheInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataCacheInterceptor.class);
    private static final MediaType mediaType = MediaType.parse("application/json");
    private final Cache<String, String> metaDataCache;

    public MetadataCacheInterceptor(Properties properties) {
        Integer metaDataCacheDurationInMs = PropertiesExtensions.getIntegerOrDefault(properties, "metadataCacheTtlMs", 10000);
        this.metaDataCache = CacheBuilder.newBuilder().expireAfterWrite(metaDataCacheDurationInMs.intValue(), TimeUnit.MILLISECONDS).maximumSize(10L).build();
    }

    @Override
    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (chain == null) {
            throw new IllegalArgumentException("chain is marked non-null but is null");
        }
        Request request = chain.request();
        String cacheKey = request.url().toString();
        String cachedResponse = this.metaDataCache.getIfPresent(cacheKey);
        Response.Builder builder = new Response.Builder().code(200).request(request).protocol(Protocol.HTTP_1_1).message("OK");
        if (cachedResponse != null) {
            log.trace("Getting the metadata response from local cache");
            builder.body(ResponseBody.create(cachedResponse, mediaType));
        } else {
            log.trace("Cache miss for metadata response. Getting from server");
            Response response = chain.proceed(request);
            if (response.isSuccessful()) {
                Optional.of(response).map(Response::body).map(t2 -> {
                    try {
                        return t2.string();
                    }
                    catch (IOException ex) {
                        log.error("Caught exception when extracting body from response. {}", (Object)cacheKey, (Object)ex);
                        return null;
                    }
                }).ifPresent(responseString -> {
                    builder.body(ResponseBody.create(responseString, mediaType));
                    this.metaDataCache.put(cacheKey, (String)responseString);
                });
            } else {
                return response;
            }
        }
        return builder.build();
    }
}

