/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.logging;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ThrowingJdbcSupplier;
import java.sql.SQLException;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;

public final class ElapsedLogger {
    public static <T> T logTimedValue(ThrowingJdbcSupplier<T> supplier, String name, Logger logger) throws DataCloudJDBCException {
        long start = System.currentTimeMillis();
        try {
            logger.info("Starting name={}", (Object)name);
            T result = supplier.get();
            long elapsed = System.currentTimeMillis() - start;
            logger.info("Success name={}, millis={}, duration={}", name, elapsed, Duration.ofMillis(elapsed));
            return result;
        }
        catch (DataCloudJDBCException e) {
            long elapsed = System.currentTimeMillis() - start;
            logger.error("Failed name={}, millis={}, duration={}", name, elapsed, Duration.ofMillis(elapsed), e);
            throw e;
        }
        catch (SQLException e) {
            long elapsed = System.currentTimeMillis() - start;
            logger.error("Failed name={}, millis={}, duration={}", name, elapsed, Duration.ofMillis(elapsed), e);
            throw new DataCloudJDBCException(e);
        }
    }

    @Generated
    private ElapsedLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

