/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.soql;

import com.salesforce.datacloud.jdbc.auth.OAuthToken;
import com.salesforce.datacloud.jdbc.auth.TokenProcessor;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.ClientBuilder;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import com.salesforce.datacloud.jdbc.logging.ElapsedLogger;
import com.salesforce.datacloud.jdbc.soql.DataspaceResponse;
import com.salesforce.datacloud.jdbc.tracing.Tracer;
import com.salesforce.datacloud.jdbc.util.ThrowingJdbcSupplier;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableMap;
import com.salesforce.datacloud.shaded.okhttp3.OkHttpClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataspaceClient
implements ThrowingJdbcSupplier<List<String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataspaceClient.class);
    private static final String SOQL_ENDPOINT_SUFFIX = "services/data/v61.0/query/";
    private static final String SOQL_QUERY_PARAM_KEY = "q";
    private final TokenProcessor tokenProcessor;
    private final OkHttpClient client;
    private static final String TRACE_ID = "x-b3-traceid";
    private static final String SPAN_ID = "x-b3-spanid";

    public DataspaceClient(Properties properties, TokenProcessor tokenProcessor) {
        this.tokenProcessor = tokenProcessor;
        this.client = ClientBuilder.buildOkHttpClient(properties);
    }

    @Override
    public List<String> get() throws SQLException {
        return ElapsedLogger.logTimedValue(this::getWithoutLogging, "getDataspaces", log);
    }

    private List<String> getWithoutLogging() throws SQLException {
        try {
            DataspaceResponse dataspaceResponse = this.getDataSpaceResponse();
            return dataspaceResponse.getRecords().stream().map(DataspaceResponse.DataSpaceAttributes::getName).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DataCloudJDBCException(e);
        }
    }

    private DataspaceResponse getDataSpaceResponse() throws SQLException {
        try {
            OAuthToken token = this.tokenProcessor.getOAuthToken();
            FormCommand command = DataspaceClient.buildGetDataspaceFormCommand(token);
            return FormCommand.get(this.client, command, DataspaceResponse.class);
        }
        catch (Exception e) {
            throw new DataCloudJDBCException(e);
        }
    }

    private static FormCommand buildGetDataspaceFormCommand(OAuthToken oAuthToken) throws URISyntaxException {
        String traceId = Tracer.get().nextId();
        String spanId = Tracer.get().nextSpanId();
        FormCommand.Builder builder = FormCommand.builder();
        builder.url(oAuthToken.getInstanceUrl());
        builder.suffix(new URI(SOQL_ENDPOINT_SUFFIX));
        builder.queryParameters(ImmutableMap.of(SOQL_QUERY_PARAM_KEY, "SELECT+name+from+Dataspace"));
        builder.header("Authorization", oAuthToken.getBearerToken());
        builder.header("Content-Type", "application/json");
        builder.header("User-Agent", "cdp/jdbc");
        builder.header("enable-stream-flow", "false");
        builder.header(TRACE_ID, traceId);
        builder.header(SPAN_ID, spanId);
        return builder.build();
    }
}

