/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.tracing;

import com.salesforce.datacloud.jdbc.tracing.EncodingUtils;
import com.salesforce.datacloud.jdbc.tracing.TemporaryBuffers;
import java.util.concurrent.ThreadLocalRandom;

public class Tracer {
    private static final int TRACE_ID_BYTES_LENGTH = 16;
    private static final int TRACE_ID_HEX_LENGTH = 32;
    private static final int SPAN_ID_BYTES_LENGTH = 8;
    private static final int SPAN_ID_HEX_LENGTH = 16;
    private static final long INVALID_ID = 0L;
    private static final String INVALID = "0000000000000000";
    private static volatile Tracer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Tracer get() {
        if (instance != null) return instance;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (instance != null) return instance;
            instance = new Tracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String nextSpanId() {
        long id;
        while ((id = this.randomLong()) == 0L) {
        }
        return this.fromLong(id);
    }

    public boolean isValidSpanId(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && EncodingUtils.isValidBase16String(spanId);
    }

    private String fromLong(long id) {
        if (id == 0L) {
            return INVALID;
        }
        char[] result = TemporaryBuffers.chars(16);
        EncodingUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }

    private long randomLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public String nextId() {
        long idLo;
        long idHi = this.randomLong();
        while ((idLo = this.randomLong()) == 0L) {
        }
        return this.fromLongs(idHi, idLo);
    }

    public boolean isValidTraceId(CharSequence traceId) {
        return traceId != null && traceId.length() == 32 && !INVALID.contentEquals(traceId) && EncodingUtils.isValidBase16String(traceId);
    }

    private String fromLongs(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return INVALID;
        }
        char[] chars = TemporaryBuffers.chars(32);
        EncodingUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        EncodingUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars, 0, 32);
    }
}

