/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.TimeZone;
import lombok.Generated;

public final class DateTimeUtils {
    public static final long MILLIS_TO_MICRO_SECS_CONVERSION_FACTOR = 1000L;

    public static long applyCalendarOffset(long milliseconds) {
        TimeZone defaultTz = TimeZone.getDefault();
        return milliseconds - (long)defaultTz.getOffset(milliseconds);
    }

    public static long applyCalendarOffset(long milliseconds, Calendar calendar) {
        if (calendar == null) {
            return DateTimeUtils.applyCalendarOffset(milliseconds);
        }
        TimeZone timeZone = calendar.getTimeZone();
        return milliseconds - (long)timeZone.getOffset(milliseconds);
    }

    public static Date getUTCDateFromMilliseconds(long milliseconds) {
        return new Date(DateTimeUtils.applyCalendarOffset(milliseconds));
    }

    public static Time getUTCTimeFromMilliseconds(long milliseconds) {
        return new Time(DateTimeUtils.applyCalendarOffset(milliseconds));
    }

    public static Date getUTCDateFromDateAndCalendar(Date date, Calendar calendar) {
        long milliseconds = date.getTime();
        return new Date(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
    }

    public static Time getUTCTimeFromTimeAndCalendar(Time time, Calendar calendar) {
        long milliseconds = time.getTime();
        return new Time(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
    }

    public static Timestamp getUTCTimestampFromTimestampAndCalendar(Timestamp timestamp, Calendar calendar) {
        long milliseconds = timestamp.getTime();
        return new Timestamp(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
    }

    public static long localDateTimeToMicrosecondsSinceEpoch(LocalDateTime localDateTime) {
        long epochMillis = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        return DateTimeUtils.millisToMicrosecondsSinceMidnight(epochMillis);
    }

    public static long millisToMicrosecondsSinceMidnight(long millis) {
        return millis * 1000L;
    }

    public static LocalDateTime adjustForCalendar(LocalDateTime localDateTime, Calendar calendar, TimeZone defaultTimeZone) {
        if (calendar == null) {
            return localDateTime;
        }
        TimeZone targetTimeZone = calendar.getTimeZone();
        long millis = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        long offsetMillis = (long)targetTimeZone.getOffset(millis) - (long)defaultTimeZone.getOffset(millis);
        return localDateTime.plus(offsetMillis, ChronoUnit.MILLIS);
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

