/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.BigIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.BitVectorSetter;
import com.salesforce.datacloud.jdbc.util.DateDayVectorSetter;
import com.salesforce.datacloud.jdbc.util.DecimalVectorSetter;
import com.salesforce.datacloud.jdbc.util.Float4VectorSetter;
import com.salesforce.datacloud.jdbc.util.Float8VectorSetter;
import com.salesforce.datacloud.jdbc.util.IntVectorSetter;
import com.salesforce.datacloud.jdbc.util.SmallIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeMicroVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeStampMicroTZVectorSetter;
import com.salesforce.datacloud.jdbc.util.TinyIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.VarCharVectorSetter;
import com.salesforce.datacloud.jdbc.util.VectorValueSetter;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableMap;
import com.salesforce.datacloud.shaded.com.google.common.collect.Maps;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BigIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BitVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.DateDayVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.DecimalVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.Float4Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.Float8Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.IntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.SmallIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeMicroVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMicroTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TinyIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VarCharVector;
import java.util.Calendar;
import java.util.Map;

class VectorValueSetterFactory {
    private final Map<Class<? extends ValueVector>, VectorValueSetter<?>> setterMap;

    VectorValueSetterFactory(Calendar calendar) {
        this.setterMap = ImmutableMap.ofEntries(Maps.immutableEntry(VarCharVector.class, new VarCharVectorSetter()), Maps.immutableEntry(Float4Vector.class, new Float4VectorSetter()), Maps.immutableEntry(Float8Vector.class, new Float8VectorSetter()), Maps.immutableEntry(IntVector.class, new IntVectorSetter()), Maps.immutableEntry(SmallIntVector.class, new SmallIntVectorSetter()), Maps.immutableEntry(BigIntVector.class, new BigIntVectorSetter()), Maps.immutableEntry(BitVector.class, new BitVectorSetter()), Maps.immutableEntry(DecimalVector.class, new DecimalVectorSetter()), Maps.immutableEntry(DateDayVector.class, new DateDayVectorSetter()), Maps.immutableEntry(TimeMicroVector.class, new TimeMicroVectorSetter(calendar)), Maps.immutableEntry(TimeStampMicroTZVector.class, new TimeStampMicroTZVectorSetter(calendar)), Maps.immutableEntry(TinyIntVector.class, new TinyIntVectorSetter()));
    }

    <T extends ValueVector> VectorValueSetter<T> getSetter(Class<T> vectorClass) {
        return this.setterMap.get(vectorClass);
    }
}

