/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.query.v3;

import com.salesforce.datacloud.jdbc.util.Unstable;
import java.util.Optional;
import lombok.Generated;
import salesforce.cdp.hyperdb.v1.QueryInfo;
import salesforce.cdp.hyperdb.v1.QueryStatus;

@Unstable
public final class DataCloudQueryStatus {
    private final String queryId;
    private final long chunkCount;
    private final long rowCount;
    private final double progress;
    private final CompletionStatus completionStatus;

    public boolean allResultsProduced() {
        return this.isResultProduced() || this.isExecutionFinished();
    }

    public boolean isResultProduced() {
        return this.completionStatus == CompletionStatus.RESULTS_PRODUCED;
    }

    public boolean isExecutionFinished() {
        return this.completionStatus == CompletionStatus.FINISHED;
    }

    public static Optional<DataCloudQueryStatus> of(QueryInfo queryInfo) {
        return Optional.ofNullable(queryInfo).map(QueryInfo::getQueryStatus).map(DataCloudQueryStatus::of);
    }

    public static DataCloudQueryStatus of(QueryStatus s2) {
        CompletionStatus completionStatus = DataCloudQueryStatus.of(s2.getCompletionStatus());
        return new DataCloudQueryStatus(s2.getQueryId(), s2.getChunkCount(), s2.getRowCount(), s2.getProgress(), completionStatus);
    }

    private static CompletionStatus of(QueryStatus.CompletionStatus completionStatus) {
        switch (completionStatus) {
            case RUNNING_OR_UNSPECIFIED: {
                return CompletionStatus.RUNNING;
            }
            case RESULTS_PRODUCED: {
                return CompletionStatus.RESULTS_PRODUCED;
            }
            case FINISHED: {
                return CompletionStatus.FINISHED;
            }
        }
        throw new IllegalArgumentException("Unknown completion status. status=" + completionStatus);
    }

    @Generated
    public DataCloudQueryStatus(String queryId, long chunkCount, long rowCount, double progress, CompletionStatus completionStatus) {
        this.queryId = queryId;
        this.chunkCount = chunkCount;
        this.rowCount = rowCount;
        this.progress = progress;
        this.completionStatus = completionStatus;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public long getChunkCount() {
        return this.chunkCount;
    }

    @Generated
    public long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public double getProgress() {
        return this.progress;
    }

    @Generated
    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCloudQueryStatus)) {
            return false;
        }
        DataCloudQueryStatus other = (DataCloudQueryStatus)o;
        if (this.getChunkCount() != other.getChunkCount()) {
            return false;
        }
        if (this.getRowCount() != other.getRowCount()) {
            return false;
        }
        if (Double.compare(this.getProgress(), other.getProgress()) != 0) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        CompletionStatus this$completionStatus = this.getCompletionStatus();
        CompletionStatus other$completionStatus = other.getCompletionStatus();
        return !(this$completionStatus == null ? other$completionStatus != null : !((Object)((Object)this$completionStatus)).equals((Object)other$completionStatus));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $chunkCount = this.getChunkCount();
        result = result * 59 + (int)($chunkCount >>> 32 ^ $chunkCount);
        long $rowCount = this.getRowCount();
        result = result * 59 + (int)($rowCount >>> 32 ^ $rowCount);
        long $progress = Double.doubleToLongBits(this.getProgress());
        result = result * 59 + (int)($progress >>> 32 ^ $progress);
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        CompletionStatus $completionStatus = this.getCompletionStatus();
        result = result * 59 + ($completionStatus == null ? 43 : ((Object)((Object)$completionStatus)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataCloudQueryStatus(queryId=" + this.getQueryId() + ", chunkCount=" + this.getChunkCount() + ", rowCount=" + this.getRowCount() + ", progress=" + this.getProgress() + ", completionStatus=" + (Object)((Object)this.getCompletionStatus()) + ")";
    }

    public static enum CompletionStatus {
        RUNNING,
        RESULTS_PRODUCED,
        FINISHED;

    }
}

