/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.com.google.common.util.concurrent;

import com.salesforce.datacloud.shaded.com.google.common.annotations.GwtIncompatible;
import com.salesforce.datacloud.shaded.com.google.common.annotations.J2ktIncompatible;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.ExecutionList;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.ParametricNullness;
import com.salesforce.datacloud.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public class ListenableFutureTask<V>
extends FutureTask<V>
implements ListenableFuture<V> {
    private final ExecutionList executionList = new ExecutionList();

    public static <V> ListenableFutureTask<V> create(Callable<V> callable) {
        return new ListenableFutureTask<V>(callable);
    }

    public static <V> ListenableFutureTask<V> create(Runnable runnable2, @ParametricNullness V result) {
        return new ListenableFutureTask<V>(runnable2, result);
    }

    ListenableFutureTask(Callable<V> callable) {
        super(callable);
    }

    ListenableFutureTask(Runnable runnable2, @ParametricNullness V result) {
        super(runnable2, result);
    }

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public V get(long timeout2, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        long timeoutNanos = unit.toNanos(timeout2);
        if (timeoutNanos <= 2147483647999999999L) {
            return super.get(timeout2, unit);
        }
        return super.get(Math.min(timeoutNanos, 2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    @Override
    protected void done() {
        this.executionList.execute();
    }
}

