/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.ExecutionImpl;
import com.salesforce.datacloud.shaded.dev.failsafe.Functions;
import com.salesforce.datacloud.shaded.dev.failsafe.Policy;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.AsyncExecutionInternal;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionResult;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.FailsafeFuture;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.PolicyExecutor;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

final class AsyncExecutionImpl<R>
extends ExecutionImpl<R>
implements AsyncExecutionInternal<R> {
    private final FailsafeFuture<R> future;
    private final boolean asyncExecution;
    private Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> outerFn;
    private final boolean[] policyPostExecuted;
    private volatile boolean recorded;

    AsyncExecutionImpl(List<Policy<R>> policies, Scheduler scheduler, FailsafeFuture<R> future, boolean asyncExecution, Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn) {
        super(policies);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.future = future;
        this.asyncExecution = asyncExecution;
        this.outerFn = asyncExecution ? Functions.toExecutionAware(innerFn) : innerFn;
        this.outerFn = Functions.toAsync(this.outerFn, scheduler, future);
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.applyAsync(this.outerFn, scheduler, future);
        }
    }

    private AsyncExecutionImpl(AsyncExecutionImpl<R> execution) {
        super(execution);
        this.policyPostExecuted = new boolean[this.policyExecutors.size()];
        this.outerFn = execution.outerFn;
        this.future = execution.future;
        this.asyncExecution = execution.asyncExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        Assert.state(!this.recorded, "The most recent execution has already been recorded or completed", new Object[0]);
        this.recorded = true;
        FailsafeFuture<R> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            ExecutionResult result = this.result != null ? this.result : ExecutionResult.none();
            this.complete(this.postExecute(result), null);
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(R result, Throwable exception) {
        Assert.state(!this.recorded, "The most recent execution has already been recorded or completed", new Object[0]);
        this.recorded = true;
        FailsafeFuture<R> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            if (!this.attemptRecorded) {
                Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
                this.record(new ExecutionResult<R>(result, exception));
            }
            this.executeAsync();
        }
    }

    @Override
    public void recordResult(R result) {
        this.record(result, null);
    }

    @Override
    public void recordException(Throwable exception) {
        this.record(null, exception);
    }

    @Override
    public boolean isAsyncExecution() {
        return this.asyncExecution;
    }

    @Override
    public boolean isRecorded() {
        return this.recorded;
    }

    @Override
    public synchronized void setPostExecuted(int policyIndex) {
        this.policyPostExecuted[policyIndex] = true;
    }

    @Override
    public synchronized boolean isPostExecuted(int policyIndex) {
        return this.policyPostExecuted[policyIndex];
    }

    @Override
    public AsyncExecutionInternal<R> copy() {
        return new AsyncExecutionImpl<R>(this);
    }

    void executeAsync() {
        this.outerFn.apply(this).whenComplete(this::complete);
    }

    private void complete(ExecutionResult<R> result, Throwable error) {
        if (result == null && error == null) {
            return;
        }
        this.completed = true;
        if (!this.future.isDone()) {
            if (result != null) {
                this.future.completeResult(result);
            } else {
                if (error instanceof CompletionException) {
                    error = error.getCause();
                }
                this.future.completeResult(ExecutionResult.exception(error));
            }
        }
    }
}

