/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.Policy;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedRunnable;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionInternal;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionResult;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class ExecutionImpl<R>
implements ExecutionInternal<R> {
    final List<PolicyExecutor<R>> policyExecutors;
    private volatile Instant startTime;
    private final AtomicInteger attempts;
    private final AtomicInteger executions;
    private final AtomicReference<ExecutionInternal<R>> latest;
    private final ExecutionResult<R> previousResult;
    volatile ExecutionResult<R> result;
    private volatile Instant attemptStartTime;
    volatile int cancelledIndex = Integer.MIN_VALUE;
    volatile CheckedRunnable cancelCallback;
    private volatile boolean preExecuted;
    volatile boolean attemptRecorded;
    volatile boolean completed;

    ExecutionImpl(List<? extends Policy<R>> policies) {
        this.policyExecutors = new ArrayList<PolicyExecutor<R>>(policies.size());
        this.attempts = new AtomicInteger();
        this.executions = new AtomicInteger();
        this.latest = new AtomicReference<ExecutionImpl>(this);
        this.previousResult = null;
        ListIterator<Policy<R>> policyIterator = policies.listIterator(policies.size());
        int i = 0;
        while (policyIterator.hasPrevious()) {
            Policy<R> policy = Assert.notNull(policyIterator.previous(), "policies");
            PolicyExecutor<R> policyExecutor = policy.toExecutor(i);
            this.policyExecutors.add(policyExecutor);
            ++i;
        }
    }

    ExecutionImpl(ExecutionImpl<R> execution) {
        this.policyExecutors = execution.policyExecutors;
        this.startTime = execution.startTime;
        this.attempts = execution.attempts;
        this.executions = execution.executions;
        this.latest = execution.latest;
        this.latest.set(this);
        this.previousResult = execution.result;
    }

    ExecutionImpl(ExecutionResult<R> previousResult) {
        this.policyExecutors = null;
        this.attempts = new AtomicInteger();
        this.executions = new AtomicInteger();
        this.latest = new AtomicReference<ExecutionImpl>(this);
        this.previousResult = previousResult;
    }

    @Override
    public ExecutionResult<R> getResult() {
        return this.result;
    }

    @Override
    public void onCancel(CheckedRunnable cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    @Override
    public synchronized void preExecute() {
        if (!this.preExecuted) {
            this.attemptStartTime = Instant.now();
            if (this.startTime == null) {
                this.startTime = this.attemptStartTime;
            }
            this.preExecuted = true;
        }
    }

    @Override
    public boolean isPreExecuted() {
        return this.preExecuted;
    }

    @Override
    public synchronized void recordAttempt() {
        if (!this.attemptRecorded) {
            this.attempts.incrementAndGet();
            this.attemptRecorded = true;
        }
    }

    @Override
    public synchronized void record(ExecutionResult<R> result) {
        if (this.preExecuted && !this.attemptRecorded) {
            this.recordAttempt();
            this.executions.incrementAndGet();
            this.result = result;
        }
    }

    synchronized ExecutionResult<R> postExecute(ExecutionResult<R> result) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        this.record(result);
        boolean allComplete = true;
        for (PolicyExecutor<R> policyExecutor : this.policyExecutors) {
            result = policyExecutor.postExecute(this, result);
            allComplete = allComplete && result.isComplete();
        }
        this.completed = allComplete;
        return result;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.isCancelled();
        if (!cancelled) {
            this.cancelledIndex = Integer.MAX_VALUE;
            if (this.cancelCallback != null) {
                try {
                    this.cancelCallback.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return !cancelled && !this.completed;
    }

    @Override
    public void cancel(PolicyExecutor<R> policyExecutor) {
        this.cancelledIndex = policyExecutor.getPolicyIndex();
        if (this.cancelCallback != null) {
            try {
                this.cancelCallback.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelledIndex > Integer.MIN_VALUE;
    }

    @Override
    public boolean isCancelled(PolicyExecutor<R> policyExecutor) {
        return this.cancelledIndex > policyExecutor.getPolicyIndex();
    }

    @Override
    public Object getLock() {
        return this.latest;
    }

    @Override
    public ExecutionInternal<R> getLatest() {
        return this.latest.get();
    }

    @Override
    public Duration getElapsedTime() {
        return this.startTime == null ? Duration.ZERO : Duration.between(this.startTime, Instant.now());
    }

    @Override
    public Duration getElapsedAttemptTime() {
        return this.attemptStartTime == null ? Duration.ZERO : Duration.between(this.attemptStartTime, Instant.now());
    }

    @Override
    public int getAttemptCount() {
        return this.attempts.get();
    }

    @Override
    public int getExecutionCount() {
        return this.executions.get();
    }

    @Override
    public <T extends Throwable> T getLastException() {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return (T)(r == null ? null : r.getException());
    }

    @Override
    public R getLastResult() {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return r == null ? null : (R)r.getResult();
    }

    @Override
    public R getLastResult(R defaultValue) {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return r == null ? defaultValue : r.getResult();
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isFirstAttempt() {
        return this.attempts.get() == (!this.attemptRecorded ? 0 : 1);
    }

    @Override
    public boolean isRetry() {
        return this.attempts.get() > (!this.attemptRecorded ? 0 : 1);
    }

    public String toString() {
        return "[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.getLastResult() + ", lastException=" + this.getLastException() + ']';
    }
}

