/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.PolicyBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.RateLimiter;
import com.salesforce.datacloud.shaded.dev.failsafe.RateLimiterConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.RateLimiterImpl;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public class RateLimiterBuilder<R>
extends PolicyBuilder<RateLimiterBuilder<R>, RateLimiterConfig<R>, R> {
    RateLimiterBuilder(Duration executionRate) {
        super(new RateLimiterConfig(executionRate));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(long maxPermits, Duration period) {
        super(new RateLimiterConfig(maxPermits, period));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(RateLimiterConfig<R> config) {
        super(new RateLimiterConfig<R>(config));
    }

    public RateLimiter<R> build() {
        return new RateLimiterImpl(new RateLimiterConfig((RateLimiterConfig)this.config));
    }

    public RateLimiterBuilder<R> withMaxWaitTime(Duration maxWaitTime) {
        ((RateLimiterConfig)this.config).maxWaitTime = Assert.notNull(maxWaitTime, "maxWaitTime");
        return this;
    }
}

