/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe.internal;

import com.salesforce.datacloud.shaded.dev.failsafe.ExecutionContext;
import com.salesforce.datacloud.shaded.dev.failsafe.event.EventListener;
import com.salesforce.datacloud.shaded.dev.failsafe.event.ExecutionAttemptedEvent;
import com.salesforce.datacloud.shaded.dev.failsafe.event.ExecutionCompletedEvent;
import com.salesforce.datacloud.shaded.dev.failsafe.event.ExecutionScheduledEvent;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionCompletedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionAttemptedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionScheduledEvent(result.getResult(), result.getException(), Duration.ofNanos(result.getDelay()), context));
    }
}

