/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe.internal;

import com.salesforce.datacloud.shaded.dev.failsafe.Timeout;
import com.salesforce.datacloud.shaded.dev.failsafe.TimeoutConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.TimeoutExceededException;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.TimeoutImpl;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.AsyncExecutionInternal;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionInternal;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionResult;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.FailsafeFuture;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.PolicyExecutor;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.Scheduler;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class TimeoutExecutor<R>
extends PolicyExecutor<R> {
    private final Timeout<R> policy;
    private final TimeoutConfig<R> config;

    public TimeoutExecutor(TimeoutImpl<R> timeout2, int policyIndex) {
        super(timeout2, policyIndex);
        this.policy = timeout2;
        this.config = timeout2.getConfig();
    }

    @Override
    public boolean isFailure(ExecutionResult<R> result) {
        return !result.isNonResult() && result.getException() instanceof TimeoutExceededException;
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ScheduledFuture<?> timeoutFuture;
            AtomicReference<ExecutionResult> result = new AtomicReference<ExecutionResult>();
            try {
                timeoutFuture = Scheduler.DEFAULT.schedule(() -> {
                    ExecutionResult cancelResult = ExecutionResult.exception(new TimeoutExceededException(this.policy));
                    if (result.compareAndSet(null, cancelResult)) {
                        Object object = execution.getLock();
                        synchronized (object) {
                            ExecutionInternal latestExecution = execution.getLatest();
                            latestExecution.record(cancelResult);
                            latestExecution.cancel(this);
                            if (this.config.canInterrupt()) {
                                execution.interrupt();
                            }
                        }
                    }
                    return null;
                }, this.config.getTimeout().toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Throwable t2) {
                return this.postExecute(execution, ExecutionResult.exception(t2));
            }
            if (result.compareAndSet(null, (ExecutionResult)innerFn.apply((SyncExecutionInternal<R>)execution))) {
                timeoutFuture.cancel(false);
            }
            return this.postExecute(execution, (ExecutionResult)result.get());
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> {
            AtomicReference resultRef = new AtomicReference();
            AtomicReference timeoutFutureRef = new AtomicReference();
            CompletableFuture promise = new CompletableFuture();
            FailsafeFuture failsafeFuture = future;
            synchronized (failsafeFuture) {
                if (!future.isDone() && !execution.isRecorded()) {
                    try {
                        ScheduledFuture<?> timeoutFuture = Scheduler.DEFAULT.schedule(() -> {
                            ExecutionResult cancelResult = ExecutionResult.exception(new TimeoutExceededException(this.policy));
                            if (resultRef.compareAndSet(null, cancelResult)) {
                                Object object = execution.getLock();
                                synchronized (object) {
                                    ExecutionInternal latestExecution = execution.getLatest();
                                    latestExecution.record(cancelResult);
                                    latestExecution.cancel(this);
                                    future.cancelDependencies(this, this.config.canInterrupt(), cancelResult);
                                }
                            }
                            return null;
                        }, this.config.getTimeout().toNanos(), TimeUnit.NANOSECONDS);
                        timeoutFutureRef.set(timeoutFuture);
                        future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                            timeoutFuture.cancel((boolean)mayInterrupt);
                            resultRef.compareAndSet(null, cancelResult);
                        });
                    }
                    catch (Throwable t2) {
                        promise.completeExceptionally(t2);
                        return promise;
                    }
                }
            }
            ((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).whenComplete((result, error) -> {
                if (error != null) {
                    promise.completeExceptionally((Throwable)error);
                    return;
                }
                if (!resultRef.compareAndSet(null, result)) {
                    result = (ExecutionResult)resultRef.get();
                }
                if (result != null) {
                    Future timeoutFuture = (Future)timeoutFutureRef.get();
                    if (timeoutFuture != null && !timeoutFuture.isDone()) {
                        timeoutFuture.cancel(false);
                    }
                    this.postExecuteAsync(execution, result, scheduler, future);
                }
                promise.complete(result);
            });
            return promise;
        };
    }
}

