/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.grpc.internal;

import com.salesforce.datacloud.shaded.com.google.common.annotations.VisibleForTesting;
import com.salesforce.datacloud.shaded.com.google.common.base.Preconditions;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.salesforce.datacloud.shaded.com.google.common.util.concurrent.SettableFuture;
import com.salesforce.datacloud.shaded.io.grpc.CallOptions;
import com.salesforce.datacloud.shaded.io.grpc.ClientStreamTracer;
import com.salesforce.datacloud.shaded.io.grpc.InternalChannelz;
import com.salesforce.datacloud.shaded.io.grpc.InternalLogId;
import com.salesforce.datacloud.shaded.io.grpc.Metadata;
import com.salesforce.datacloud.shaded.io.grpc.MethodDescriptor;
import com.salesforce.datacloud.shaded.io.grpc.Status;
import com.salesforce.datacloud.shaded.io.grpc.internal.ClientStream;
import com.salesforce.datacloud.shaded.io.grpc.internal.ClientStreamListener;
import com.salesforce.datacloud.shaded.io.grpc.internal.ClientTransport;
import com.salesforce.datacloud.shaded.io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

