/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Nameable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.ParameterReadable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameters;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Registry;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ParameterMap
implements Map<String, Object>,
ParameterReadable,
Nameable {
    protected final Registry<String, ? extends Parameter<?>> PARAMS;
    protected final Map<String, Object> values;
    protected final Map<String, Object> idiomaticValues;
    private final boolean initialized;
    private final boolean mutable;

    public ParameterMap(Set<Parameter<?>> params) {
        this(Parameters.registry(params));
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry) {
        this(registry, null, true);
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry, Map<String, ?> values2) {
        this(registry, Assert.notNull(values2, "Map argument cannot be null."), false);
    }

    public ParameterMap(Registry<String, ? extends Parameter<?>> registry, Map<String, ?> values2, boolean mutable) {
        Assert.notNull(registry, "Parameter registry cannot be null.");
        Assert.notEmpty(registry.values(), "Parameter registry cannot be empty.");
        this.PARAMS = registry;
        this.values = new LinkedHashMap<String, Object>();
        this.idiomaticValues = new LinkedHashMap<String, Object>();
        if (!Collections.isEmpty(values2)) {
            this.putAll((Map<? extends String, ?>)values2);
        }
        this.mutable = mutable;
        this.initialized = true;
    }

    private void assertMutable() {
        if (this.initialized && !this.mutable) {
            String msg = this.getName() + " instance is immutable and may not be modified.";
            throw new UnsupportedOperationException(msg);
        }
    }

    protected ParameterMap replace(Parameter<?> param) {
        Registry<String, ? extends Parameter<?>> registry = Parameters.replace(this.PARAMS, param);
        return new ParameterMap(registry, this, this.mutable);
    }

    @Override
    public String getName() {
        return "Map";
    }

    @Override
    public <T> T get(Parameter<T> param) {
        Assert.notNull(param, "Parameter cannot be null.");
        String id = Assert.hasText(param.getId(), "Parameter id cannot be null or empty.");
        Object value = this.idiomaticValues.get(id);
        return param.cast(value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.values.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.values.get(o);
    }

    @Override
    protected final <T> Object put(Parameter<T> param, Object value) {
        this.assertMutable();
        Assert.notNull(param, "Parameter cannot be null.");
        Assert.hasText(param.getId(), "Parameter id cannot be null or empty.");
        return this.apply(param, value);
    }

    @Override
    public final Object put(String name, Object value) {
        this.assertMutable();
        name = Assert.notNull(Strings.clean(name), "Member name cannot be null or empty.");
        Parameter param = (Parameter)this.PARAMS.get(name);
        if (param != null) {
            return this.put(param, value);
        }
        return this.nullSafePut(name, value);
    }

    private Object nullSafePut(String name, Object value) {
        if (value == null) {
            return this.remove(name);
        }
        this.idiomaticValues.put(name, value);
        return this.values.put(name, value);
    }

    private <T> Object apply(Parameter<T> param, Object rawValue) {
        Object canonicalValue;
        Object idiomaticValue;
        String id = param.getId();
        if (Objects.isEmpty(rawValue)) {
            return this.remove(id);
        }
        try {
            idiomaticValue = param.applyFrom(rawValue);
            Assert.notNull(idiomaticValue, "Parameter's resulting idiomaticValue cannot be null.");
            canonicalValue = param.applyTo(idiomaticValue);
            Assert.notNull(canonicalValue, "Parameter's resulting canonicalValue cannot be null.");
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("Invalid ").append(this.getName()).append(" ").append(param).append(" value");
            if (param.isSecret()) {
                sb.append(": ").append("<redacted>");
            } else if (!(rawValue instanceof byte[])) {
                sb.append(": ").append(Objects.nullSafeToString(rawValue));
            }
            sb.append(". ").append(e.getMessage());
            String msg = sb.toString();
            throw new IllegalArgumentException(msg, e);
        }
        this.idiomaticValues.put(id, idiomaticValue);
        return this.values.put(id, canonicalValue);
    }

    @Override
    public Object remove(Object key) {
        this.assertMutable();
        this.idiomaticValues.remove(key);
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m4) {
        if (m4 == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : m4.entrySet()) {
            String s2 = entry.getKey();
            this.put(s2, entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.assertMutable();
        this.values.clear();
        this.idiomaticValues.clear();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return new ValueSet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.values.equals(obj);
    }

    private class EntryIterator
    extends ParameterMapIterator<Map.Entry<String, Object>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<String, Object> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends ParameterMapIterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends ParameterMapIterator<Object> {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private abstract class ParameterMapIterator<T>
    implements Iterator<T> {
        final Iterator<Map.Entry<String, Object>> i;
        transient Map.Entry<String, Object> current;

        ParameterMapIterator() {
            this.i = ParameterMap.this.values.entrySet().iterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        protected Map.Entry<String, Object> nextEntry() {
            this.current = this.i.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            String key = this.current.getKey();
            ParameterMap.this.remove(key);
        }
    }

    private class EntrySet
    extends ParameterMapSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }
    }

    private class ValueSet
    extends ParameterMapSet<Object> {
        private ValueSet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }
    }

    private class KeySet
    extends ParameterMapSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }
    }

    private abstract class ParameterMapSet<T>
    extends AbstractSet<T> {
        private ParameterMapSet() {
        }

        @Override
        public int size() {
            return ParameterMap.this.size();
        }
    }
}

