/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.FilteredOutputStream;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.EncodingException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteBase64UrlStreamEncoder
implements Encoder<OutputStream, OutputStream> {
    private final Encoder<byte[], String> delegate;

    public ByteBase64UrlStreamEncoder(Encoder<byte[], String> delegate) {
        this.delegate = Assert.notNull(delegate, "delegate cannot be null.");
    }

    @Override
    public OutputStream encode(OutputStream outputStream2) throws EncodingException {
        Assert.notNull(outputStream2, "outputStream cannot be null.");
        return new TranslatingOutputStream(outputStream2, this.delegate);
    }

    private static class TranslatingOutputStream
    extends FilteredOutputStream {
        private final OutputStream dst;
        private final Encoder<byte[], String> delegate;

        public TranslatingOutputStream(OutputStream dst, Encoder<byte[], String> delegate) {
            super(new ByteArrayOutputStream());
            this.dst = dst;
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            byte[] data = ((ByteArrayOutputStream)this.out).toByteArray();
            String s2 = this.delegate.encode(data);
            this.dst.write(Strings.utf8(s2));
            this.dst.flush();
            this.dst.close();
        }
    }
}

