/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.Randoms;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Arrays;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;

public final class Bytes {
    public static final byte[] EMPTY = new byte[0];
    private static final int LONG_BYTE_LENGTH = 8;
    private static final int INT_BYTE_LENGTH = 4;
    public static final String LONG_REQD_MSG = "Long byte arrays must be 8 bytes in length.";
    public static final String INT_REQD_MSG = "Integer byte arrays must be 4 bytes in length.";

    private Bytes() {
    }

    public static byte[] nullSafe(byte[] bytes) {
        return bytes != null ? bytes : EMPTY;
    }

    public static byte[] randomBits(int numBits) {
        return Bytes.random(numBits / 8);
    }

    public static byte[] random(int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("numBytes argument must be >= 0");
        }
        byte[] bytes = new byte[numBytes];
        Randoms.secureRandom().nextBytes(bytes);
        return bytes;
    }

    public static byte[] toBytes(int i) {
        return new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
    }

    public static byte[] toBytes(long l) {
        return new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
    }

    public static long toLong(byte[] bytes) {
        Assert.isTrue(Arrays.length(bytes) == 8, LONG_REQD_MSG);
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static int toInt(byte[] bytes) {
        Assert.isTrue(Arrays.length(bytes) == 4, INT_REQD_MSG);
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int indexOf(byte[] source2, byte[] target) {
        return Bytes.indexOf(source2, target, 0);
    }

    public static int indexOf(byte[] source2, byte[] target, int fromIndex) {
        return Bytes.indexOf(source2, 0, Bytes.length(source2), target, 0, Bytes.length(target), fromIndex);
    }

    static int indexOf(byte[] source2, int srcOffset, int srcLen, byte[] target, int targetOffset, int targetLen, int fromIndex) {
        if (fromIndex >= srcLen) {
            return targetLen == 0 ? srcLen : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetLen == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = srcOffset + (srcLen - targetLen);
        for (int i = srcOffset + fromIndex; i <= max; ++i) {
            if (source2[i] != first) {
                while (++i <= max && source2[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetLen - 1;
            int k = targetOffset + 1;
            while (j < end && source2[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - srcOffset;
        }
        return -1;
    }

    public static boolean startsWith(byte[] src, byte[] prefix) {
        return Bytes.startsWith(src, prefix, 0);
    }

    public static boolean startsWith(byte[] src, byte[] prefix, int offset) {
        int to = offset;
        int po = 0;
        int pc = Bytes.length(prefix);
        if (offset < 0 || offset > Bytes.length(src) - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (src[to++] == prefix[po++]) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(byte[] src, byte[] suffix) {
        return Bytes.startsWith(src, suffix, Bytes.length(src) - Bytes.length(suffix));
    }

    public static byte[] concat(byte[] ... arrays) {
        int len = 0;
        int numArrays = Arrays.length(arrays);
        for (int i = 0; i < numArrays; ++i) {
            len += Bytes.length(arrays[i]);
        }
        byte[] output = new byte[len];
        int position = 0;
        if (len > 0) {
            for (byte[] array : arrays) {
                int alen = Bytes.length(array);
                if (alen <= 0) continue;
                System.arraycopy(array, 0, output, position, alen);
                position += alen;
            }
        }
        return output;
    }

    public static void clear(byte[] bytes) {
        if (Bytes.isEmpty(bytes)) {
            return;
        }
        java.util.Arrays.fill(bytes, (byte)0);
    }

    public static boolean isEmpty(byte[] bytes) {
        return Bytes.length(bytes) == 0;
    }

    public static int length(byte[] bytes) {
        return bytes == null ? 0 : bytes.length;
    }

    public static long bitLength(byte[] bytes) {
        return (long)Bytes.length(bytes) * 8L;
    }

    public static int length(int bitLength) {
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitLength argument must be >= 0");
        }
        return (bitLength + 7) / 8;
    }

    public static String bitsMsg(long bitLength) {
        return bitLength + " bits (" + bitLength / 8L + " bytes)";
    }

    public static String bytesMsg(int byteArrayLength) {
        return Bytes.bitsMsg((long)byteArrayLength * 8L);
    }

    public static void increment(byte[] a) {
        int i = a.length - 1;
        while (i >= 0) {
            int n = i--;
            a[n] = (byte)(a[n] + 1);
            if (a[n] != 0) break;
        }
    }

    public static byte[] prepad(byte[] bytes, int length) {
        Assert.notNull(bytes, "byte array cannot be null.");
        Assert.gt(length, 0, "length must be positive (> 0).");
        if (bytes.length < length) {
            byte[] padded = new byte[length];
            System.arraycopy(bytes, 0, padded, length - bytes.length, bytes.length);
            bytes = padded;
        }
        return bytes;
    }
}

