/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Identifiable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.CollectionMutator;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;

public class DefaultCollectionMutator<E, M extends CollectionMutator<E, M>>
implements CollectionMutator<E, M> {
    private final Collection<E> collection;

    public DefaultCollectionMutator(Collection<? extends E> seed) {
        this.collection = new LinkedHashSet<E>(Collections.nullSafe(seed));
    }

    protected final M self() {
        return (M)this;
    }

    private boolean doAdd(E e) {
        if (Objects.isEmpty(e)) {
            return false;
        }
        if (e instanceof Identifiable && !Strings.hasText(((Identifiable)e).getId())) {
            String msg = e.getClass() + " getId() value cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        return this.collection.add(e);
    }

    @Override
    public M add(E e) {
        if (this.doAdd(e)) {
            this.changed();
        }
        return this.self();
    }

    @Override
    public M remove(E e) {
        if (this.collection.remove(e)) {
            this.changed();
        }
        return this.self();
    }

    @Override
    public M add(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : Collections.nullSafe(c)) {
            changed = this.doAdd(element) || changed;
        }
        if (changed) {
            this.changed();
        }
        return this.self();
    }

    @Override
    public M clear() {
        boolean changed = !Collections.isEmpty(this.collection);
        this.collection.clear();
        if (changed) {
            this.changed();
        }
        return this.self();
    }

    protected void changed() {
    }

    protected Collection<E> getCollection() {
        return Collections.immutable(this.collection);
    }
}

