/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.DelegatingCheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.FormattedStringFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.FormattedStringSupplier;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Function;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.PropagatingExceptionFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;

public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T t2) {
                return t2;
            }
        };
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrapFmt(CheckedFunction<T, R> fn, Class<E> exClass, String msg) {
        return new PropagatingExceptionFunction<T, R, E>(fn, exClass, new FormattedStringFunction(msg));
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrap(Function<T, R> fn, Class<E> exClass, String fmt, Object ... args2) {
        return new PropagatingExceptionFunction<T, R, E>(new DelegatingCheckedFunction<T, R>(fn), exClass, new FormattedStringSupplier(fmt, args2));
    }

    public static <T, V, R> Function<T, R> andThen(final Function<T, ? extends V> before, final Function<V, R> after) {
        Assert.notNull(before, "Before function cannot be null.");
        Assert.notNull(after, "After function cannot be null.");
        return new Function<T, R>(){

            @Override
            public R apply(T t2) {
                Object result = before.apply(t2);
                return after.apply(result);
            }
        };
    }

    @SafeVarargs
    public static <T, R> Function<T, R> firstResult(final Function<T, R> ... fns) {
        Assert.notEmpty(fns, "Function list cannot be null or empty.");
        return new Function<T, R>(){

            @Override
            public R apply(T t2) {
                for (Function fn : fns) {
                    Assert.notNull(fn, "Function cannot be null.");
                    Object result = fn.apply(t2);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

