/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.RedactedSupplier;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Supplier;

public class RedactedValueConverter<T>
implements Converter<T, Object> {
    private final Converter<T, Object> delegate;

    public RedactedValueConverter(Converter<T, Object> delegate) {
        this.delegate = Assert.notNull(delegate, "Delegate cannot be null.");
    }

    @Override
    public Object applyTo(T t2) {
        RedactedSupplier<Object> value = this.delegate.applyTo(t2);
        if (value != null && !(value instanceof RedactedSupplier)) {
            value = new RedactedSupplier<Object>(value);
        }
        return value;
    }

    @Override
    public T applyFrom(Object o) {
        if (o instanceof RedactedSupplier) {
            o = ((Supplier)o).get();
        }
        return this.delegate.applyFrom(o);
    }
}

