/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Header;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JwtException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.MalformedJwtException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Nameable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.ParameterReadable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.MalformedKeyException;

public class RequiredParameterReader
implements ParameterReadable {
    private final ParameterReadable src;

    public RequiredParameterReader(Header header) {
        this(Assert.isInstanceOf(ParameterReadable.class, header, "Header implementations must implement ParameterReadable: "));
    }

    public RequiredParameterReader(ParameterReadable src) {
        this.src = Assert.notNull(src, "Source ParameterReadable cannot be null.");
        Assert.isInstanceOf(Nameable.class, src, "ParameterReadable implementations must implement Nameable.");
    }

    private String name() {
        return ((Nameable)((Object)this.src)).getName();
    }

    private JwtException malformed(String msg) {
        if (this.src instanceof JwkContext || this.src instanceof Jwk) {
            return new MalformedKeyException(msg);
        }
        return new MalformedJwtException(msg);
    }

    @Override
    public <T> T get(Parameter<T> param) {
        T value = this.src.get(param);
        if (value == null) {
            String msg = this.name() + " is missing required " + param + " value.";
            throw this.malformed(msg);
        }
        return value;
    }
}

