/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyPair;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyPair;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.PrivateJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.PublicJwk;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;

abstract class AbstractPrivateJwk<K extends PrivateKey, L extends PublicKey, M extends PublicJwk<L>>
extends AbstractAsymmetricJwk<K>
implements PrivateJwk<K, L, M> {
    private final M publicJwk;
    private final KeyPair<L, K> keyPair;

    AbstractPrivateJwk(JwkContext<K> ctx, List<Parameter<?>> thumbprintParams, M pubJwk) {
        super(ctx, thumbprintParams);
        this.publicJwk = (PublicJwk)Assert.notNull(pubJwk, "PublicJwk instance cannot be null.");
        PublicKey publicKey = (PublicKey)Assert.notNull(pubJwk.toKey(), "PublicJwk key instance cannot be null.");
        this.context.setPublicKey(publicKey);
        this.keyPair = new DefaultKeyPair<PublicKey, PrivateKey>(publicKey, (PrivateKey)this.toKey());
    }

    @Override
    public M toPublicJwk() {
        return this.publicJwk;
    }

    @Override
    public KeyPair<L, K> toKeyPair() {
        return this.keyPair;
    }

    @Override
    protected final boolean equals(Jwk<?> jwk) {
        return jwk instanceof PrivateJwk && this.equals((PrivateJwk)jwk);
    }

    protected abstract boolean equals(PrivateJwk<?, ?, ?> var1);
}

