/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.JweHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DecryptionKeyRequest;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;

public class DefaultDecryptionKeyRequest<K extends Key>
extends DefaultKeyRequest<byte[]>
implements DecryptionKeyRequest<K> {
    private final K decryptionKey;

    public DefaultDecryptionKeyRequest(byte[] encryptedCek, Provider provider, SecureRandom secureRandom, JweHeader header, AeadAlgorithm encryptionAlgorithm, K decryptionKey) {
        super(encryptedCek, provider, secureRandom, header, encryptionAlgorithm);
        this.decryptionKey = (Key)Assert.notNull(decryptionKey, "decryption key cannot be null.");
    }

    @Override
    protected void assertBytePayload(byte[] payload) {
        Assert.notNull(payload, "encrypted key bytes cannot be null (but may be empty.");
    }

    @Override
    public K getKey() {
        return this.decryptionKey;
    }
}

