/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.ParameterMap;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameters;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkConverter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.JwkSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultJwkSet
extends ParameterMap
implements JwkSet {
    private static final String NAME = "JWK Set";
    static final Parameter<Set<Jwk<?>>> KEYS = DefaultJwkSet.param(JwkConverter.ANY);

    static Parameter<Set<Jwk<?>>> param(Converter<Jwk<?>, ?> converter) {
        return (Parameter)Parameters.builder(JwkConverter.JWK_CLASS).setConverter(converter).set().setId("keys").setName("JSON Web Keys").setSecret(true).build();
    }

    public DefaultJwkSet(Parameter<Set<Jwk<?>>> param, Map<String, ?> src) {
        super(Parameters.registry(param), src);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Jwk<?>> getKeys() {
        Set<Jwk<?>> jwks = this.get(KEYS);
        if (Collections.isEmpty(jwks)) {
            return Collections.emptySet();
        }
        return Collections.immutable(jwks);
    }

    @Override
    public Iterator<Jwk<?>> iterator() {
        return this.getKeys().iterator();
    }
}

