/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyOperation;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyOperationPolicy;
import java.util.Collection;

final class DefaultKeyOperationPolicy
implements KeyOperationPolicy {
    private final Collection<KeyOperation> ops;
    private final boolean allowUnrelated;

    DefaultKeyOperationPolicy(Collection<KeyOperation> ops, boolean allowUnrelated) {
        Assert.notEmpty(ops, "KeyOperation collection cannot be null or empty.");
        this.ops = Collections.immutable(ops);
        this.allowUnrelated = allowUnrelated;
    }

    @Override
    public Collection<KeyOperation> getOperations() {
        return this.ops;
    }

    @Override
    public void validate(Collection<? extends KeyOperation> ops) {
        if (this.allowUnrelated || Collections.isEmpty(ops)) {
            return;
        }
        for (KeyOperation keyOperation : ops) {
            for (KeyOperation keyOperation2 : ops) {
                if (keyOperation.isRelated(keyOperation2)) continue;
                String msg = "Unrelated key operations are not allowed. KeyOperation [" + keyOperation2 + "] is unrelated to [" + keyOperation + "].";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public int hashCode() {
        int hash = Boolean.valueOf(this.allowUnrelated).hashCode();
        KeyOperation[] ops = this.ops.toArray(new KeyOperation[0]);
        hash = 31 * hash + Objects.nullSafeHashCode(ops);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyOperationPolicy)) {
            return false;
        }
        DefaultKeyOperationPolicy other = (DefaultKeyOperationPolicy)obj;
        return this.allowUnrelated == other.allowUnrelated && Collections.size(this.ops) == Collections.size(other.ops) && this.ops.containsAll(other.ops);
    }
}

