/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.KeysBridge;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.RsaSignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DecryptionKeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.WeakKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class DefaultRsaKeyAlgorithm
extends CryptoAlgorithm
implements KeyAlgorithm<PublicKey, PrivateKey> {
    private final AlgorithmParameterSpec SPEC;
    private static final int MIN_KEY_BIT_LENGTH = 2048;

    public DefaultRsaKeyAlgorithm(String id, String jcaTransformationString) {
        this(id, jcaTransformationString, null);
    }

    public DefaultRsaKeyAlgorithm(String id, String jcaTransformationString, AlgorithmParameterSpec spec) {
        super(id, jcaTransformationString);
        this.SPEC = spec;
    }

    private static String keyType(boolean encryption) {
        return encryption ? "encryption" : "decryption";
    }

    protected void validate(Key key, boolean encryption) {
        if (!RsaSignatureAlgorithm.isRsaAlgorithmName(key)) {
            throw new InvalidKeyException("Invalid RSA key algorithm name.");
        }
        if (RsaSignatureAlgorithm.isPss(key)) {
            String msg = "RSASSA-PSS keys may not be used for " + DefaultRsaKeyAlgorithm.keyType(encryption) + ", only digital signature algorithms.";
            throw new InvalidKeyException(msg);
        }
        int size = KeysBridge.findBitLength(key);
        if (size < 0) {
            return;
        }
        if (size < 2048) {
            String id = this.getId();
            String section = id.startsWith("RSA1") ? "4.2" : "4.3";
            String msg = "The RSA " + DefaultRsaKeyAlgorithm.keyType(encryption) + " key size (aka modulus bit length) is " + size + " bits which is not secure enough for the " + id + " algorithm. " + "The JWT JWA Specification (RFC 7518, Section " + section + ") states that RSA keys MUST " + "have a size >= " + 2048 + " bits. See " + "https://www.rfc-editor.org/rfc/rfc7518.html#section-" + section + " for more information.";
            throw new WeakKeyException(msg);
        }
    }

    @Override
    public KeyResult getEncryptionKey(final KeyRequest<PublicKey> request) throws SecurityException {
        Assert.notNull(request, "Request cannot be null.");
        final PublicKey kek = (PublicKey)Assert.notNull(request.getPayload(), "RSA PublicKey encryption key cannot be null.");
        this.validate(kek, true);
        final SecretKey cek = this.generateCek(request);
        byte[] ciphertext = this.jca(request).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                if (DefaultRsaKeyAlgorithm.this.SPEC == null) {
                    cipher.init(3, (Key)kek, CryptoAlgorithm.ensureSecureRandom(request));
                } else {
                    cipher.init(3, (Key)kek, DefaultRsaKeyAlgorithm.this.SPEC, CryptoAlgorithm.ensureSecureRandom(request));
                }
                return cipher.wrap(cek);
            }
        });
        return new DefaultKeyResult(cek, ciphertext);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<PrivateKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final PrivateKey kek = (PrivateKey)Assert.notNull(request.getKey(), "RSA PrivateKey decryption key cannot be null.");
        this.validate(kek, false);
        final byte[] cekBytes = Assert.notEmpty((byte[])request.getPayload(), "Request content (encrypted key) cannot be null or empty.");
        return this.jca(request).withCipher(new CheckedFunction<Cipher, SecretKey>(){

            @Override
            public SecretKey apply(Cipher cipher) throws Exception {
                if (DefaultRsaKeyAlgorithm.this.SPEC == null) {
                    cipher.init(4, kek);
                } else {
                    cipher.init(4, (Key)kek, DefaultRsaKeyAlgorithm.this.SPEC);
                }
                Key key = cipher.unwrap(cekBytes, "AES", 3);
                return Assert.isInstanceOf(SecretKey.class, key, "Cipher unwrap must return a SecretKey instance.");
            }
        });
    }
}

