/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.ParameterReadable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameters;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.PublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.RsaPublicJwk;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Set;

class DefaultRsaPublicJwk
extends AbstractPublicJwk<RSAPublicKey>
implements RsaPublicJwk {
    static final String TYPE_VALUE = "RSA";
    static final Parameter<BigInteger> MODULUS = (Parameter)Parameters.bigInt("n", "Modulus").build();
    static final Parameter<BigInteger> PUBLIC_EXPONENT = (Parameter)Parameters.bigInt("e", "Public Exponent").build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(AbstractAsymmetricJwk.PARAMS, MODULUS, PUBLIC_EXPONENT);
    static final List<Parameter<?>> THUMBPRINT_PARAMS = Collections.of(PUBLIC_EXPONENT, KTY, MODULUS);

    DefaultRsaPublicJwk(JwkContext<RSAPublicKey> ctx) {
        super(ctx, THUMBPRINT_PARAMS);
    }

    static boolean equalsPublic(ParameterReadable self, Object candidate) {
        return Parameters.equals(self, candidate, MODULUS) && Parameters.equals(self, candidate, PUBLIC_EXPONENT);
    }

    @Override
    protected boolean equals(PublicJwk<?> jwk) {
        return jwk instanceof RsaPublicJwk && DefaultRsaPublicJwk.equalsPublic(this, jwk);
    }
}

